package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.LabelFigure;
import net.sf.amateras.air.mxml.models.ImageModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link ImageModel}.
 * @author Naoki Takezoe
 */
public class ImageEditPart extends AbstractComponentEditPart {

	private String oldSource;

	@Override
	protected IFigure createFigure() {
		Label label = new LabelFigure();
		updateFigure(label, (ImageModel) getModel());
		return label;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((Label) getFigure(), (ImageModel) getModel());
	}

	private void updateFigure(Label label, ImageModel model) {
		label.setToolTip(new Label(model.toString()));
		if (!model.getAttribute(ImageModel.SOURCE).equals(oldSource)) {
			oldSource = (String) model.getAttribute(ImageModel.SOURCE);
			label.setIcon(getEmbedResourceAsImage(oldSource));
		}
	}

}
