package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.DataGridColumnFigure;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;

import org.eclipse.draw2d.IFigure;

/**
 * The editpart for the {@link DataGridColumnModel}.
 * 
 * @author Hideko Ogawa
 */
public class DataGridColumnEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		DataGridColumnModel model = (DataGridColumnModel) getModel();
		DataGridColumnFigure column = new DataGridColumnFigure();
		column.setWidth(column.getDefaultWidth());
		updateFigure(column, model);
		return column;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((DataGridColumnFigure) getFigure(), (DataGridColumnModel) getModel());
	}

	private void updateFigure(DataGridColumnFigure column, DataGridColumnModel model) {
		column.setText(model.getAttributeToString(DataGridColumnModel.HEADER_TEXT));
		Object swidth = model.getAttribute(DataGridColumnModel.WIDTH);

		try {
			column.setWidth(Integer.parseInt(swidth.toString()));
		} catch (NumberFormatException e) {
			column.setWidth(100);
		}

		AIRPlugin.getDefault().getFontManager().setFont(model, column);
		column.setHeaderForegroundColor(getColor(DataGridColumnModel.COLOR));

		column.revalidate();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return DataGridColumnModel.HEADER_TEXT;
	}

	@Override
	protected IFigure getDirectEditFigure() {
		return ((DataGridColumnFigure) getFigure()).getTitleFigure();
	}

}
