package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.ComboBox;
import net.sf.amateras.air.mxml.models.ComboBoxModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link ComboBoxModel}.
 * 
 * @author ogawahideko
 */
public class ComboBoxEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		ComboBox comboBox = new ComboBox();
		updateFigure(comboBox, (ComboBoxModel) getModel());
		return comboBox;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((ComboBox) getFigure(), (ComboBoxModel) getModel());
	}

	private void updateFigure(ComboBox comboBox, ComboBoxModel model) {
		comboBox.setToolTip(new Label(model.toString()));
		AIRPlugin.getDefault().getFontManager().setFont(model, comboBox);

		if (model.getAttribute(ComboBoxModel.COLOR) != null) {
			comboBox.setForegroundColor(getColor(ComboBoxModel.COLOR));
		}
	}

}
