package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.ContainerFigure;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

/**
 * The editpart for the {@link CanvasModel}.
 * @author ogawahideko
 *
 */
public class CanvasEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		ContainerFigure figure = new ContainerFigure();
		figure.setOpaque(true);
		figure.setLayout(true);
		updateFigure((CanvasModel) getModel(), figure);
		return figure;
	}

	@Override
	protected List getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		CanvasModel model = (CanvasModel) getModel();
		ContainerFigure figure = (ContainerFigure) getFigure();
		updateFigure(model, figure);
	}

	private void updateFigure(CanvasModel model, ContainerFigure figure) {
		figure.setToolTip(new Label(model.toString()));

		int top = model.getAttributeToNumber(CanvasModel.PADDING_TOP);
		int left = model.getAttributeToNumber(CanvasModel.PADDING_LEFT);
		int right = model.getAttributeToNumber(CanvasModel.PADDING_RIGHT);
		int bottom = model.getAttributeToNumber(CanvasModel.PADDING_BOTTOM);
		figure.setPadding(new Insets(top, left, bottom, right));

		AIRPlugin.getDefault().getFontManager().setFont(model, figure);
		if (model.getAttribute(CanvasModel.COLOR) != null) {
			figure.setForegroundColor(getColor(CanvasModel.COLOR));

		}
		figure.setBackgroundColor(getColor((RGB) model.getAttribute(CanvasModel.BACKGROUND_COLOR)));

		figure.revalidate();
	}

}