package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.Button;
import net.sf.amateras.air.mxml.models.ButtonModel;
import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;

/**
 * The editpart for the {@link ButtonModel}.
 * 
 * @author Naoki Takezoe
 */
public class ButtonEditPart extends AbstractDirectEditPart {

	private String oldIcon = "";

	@Override
	protected IFigure createFigure() {
		Button button = new Button();
		updateFigure(button, (ButtonModel) getModel());
		return button;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((Button) getFigure(), (ButtonModel) getModel());
	}

	protected void updateFigure(Button button, ButtonModel model) {
		button.setToolTip(new Label(model.toString()));
		button.setText(model.getAttributeToString(ButtonModel.LABEL));

		// color
		if (model.getAttribute(ButtonModel.COLOR) != null) {
			button.setForegroundColor(getColor(ButtonModel.COLOR));

		}

		// icon
		if (!model.getAttributeToString(ButtonModel.ICON).equals(oldIcon)) {
			oldIcon = (String) model.getAttribute(ButtonModel.ICON);
			button.setIcon(getEmbedResourceAsImage(oldIcon));
		}

		// font
		AIRPlugin.getDefault().getFontManager().setFont(model, button);

		//backGroundColor
		if (model.getAttribute(ButtonModel.FILL_COLORS) != null) {
			String value = model.getAttributeToString(ButtonModel.FILL_COLORS);

			value = value.replaceAll("0x", "#");
			if (value.length() > 0) {
				value = value.substring(1, 8);
				button.setBackgroundColor(getColor(ColorUtil.toRGB(value)));
			}
		}

		//padding
		int top = model.getAttributeToNumber(ButtonModel.PADDING_TOP);
		int left = model.getAttributeToNumber(ButtonModel.PADDING_LEFT);
		int right = model.getAttributeToNumber(ButtonModel.PADDING_RIGHT);
		int bottom = model.getAttributeToNumber(ButtonModel.PADDING_BOTTOM);
		button.setPadding(new Insets(top, left, bottom, right));
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return ButtonModel.LABEL;
	}

	//	/* (non-Javadoc)
	//	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	//	 */
	//	public IAction[] getMenuActions() {
	//		ButtonModel model = (ButtonModel)getModel();
	//		return new IAction[]{
	//				createActionAction("commandButton_action", model.getLabel()),
	//				createActionListenerAction("commandButton_actionListener", model.getName())
	//		};
	//	}

}
