package net.sf.amateras.air.mxml.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.RootFigure;
import net.sf.amateras.air.mxml.models.ApplicationModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.WindowedApplicationModel;


import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

/**
 * The editpart for the {@link ApplicationModel} or {@link WindowedApplicationModel}
 * 
 * @author ogawahideko
 */
public class ApplicationEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		RootFigure figure = new RootFigure();
		updateFigure(figure);
		return figure;
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}

	@Override
	protected List getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((RootFigure) getFigure());
		refreshChildren();
	}

	private void updateFigure(RootFigure figure) {
		ApplicationModel model = (ApplicationModel) getModel();
		figure.setBackgroundColor(getColor((RGB) model.getAttribute(ApplicationModel.BACKGROUND_COLOR)));

		String direction = (String) model.getAttribute(ApplicationModel.LAYOUT);
		if (direction.equalsIgnoreCase("vertical")) {
			figure.setLayout(false);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());

		} else if (direction.equalsIgnoreCase("horizontal")) {
			figure.setLayout(false);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());

		} else {
			figure.setLayout(true);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
		}
	}

}
