package net.sf.amateras.air.mxml.editparts;

import java.beans.PropertyChangeListener;

import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.action.IAction;

/**
 * The base class for all editparts.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractEditPart extends AbstractGraphicalEditPart implements PropertyChangeListener {
	
	@Override
	public void activate() {
		super.activate();
		((AbstractModel) getModel()).addPropertyChangeListener(this);
	}

	@Override
	public void deactivate() {
		super.deactivate();
		((AbstractModel) getModel()).removePropertyChangeListener(this);
	}
	
	public IAction[] getMenuActions(){
		return null;
	}

}
