package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * PropertyDescriptor String.
 * @author ogawahideko
 *
 */
public class StringPropertyDescriptor extends TextPropertyDescriptor implements
		IEditorValueDescriptor<String> {

	private String defaultValue;

	public StringPropertyDescriptor(Object id, String displayName, String defaultValue) {
		super(id, displayName);
		this.defaultValue = defaultValue;
		if (this.defaultValue == null) {
			this.defaultValue = "";
		}
		setLabelProvider(new MyLabelDecorator());
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null) {
			return value;
		} else {
			return defaultValue;
		}
	}

	class MyLabelDecorator extends LabelProvider {
		public Image getImage(Object element) {
			if (element != defaultValue) {
				return ComponentImageRegistry.getSetPropertyImage();
			} else {
				return null;
			}
		}
	}

}
