package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * PropertyDescriptor selected from list(String[]).
 * @author ogawahideko
 *
 */
public class StringListPropertyDescriptor extends TextPropertyDescriptor implements
		IEditorValueDescriptor<String> {

	private String[] list;
	private String defaultValue;

	public StringListPropertyDescriptor(Object id, String displayName, String[] list) {
		super(id, displayName);
		this.list = list;
		if (list.length > 0) {
			defaultValue = new String(list[0]);
		}
		setLabelProvider(new MyLabelDecorator());
	}

	public StringListPropertyDescriptor(Object id, String displayName, String[] list, String defaultValue) {
		super(id, displayName);
		this.list = list;
		this.defaultValue = defaultValue;
		setLabelProvider(new MyLabelDecorator());
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new ComboBoxCellEditor(parent, list, SWT.READ_ONLY) {

			public void doSetValue(Object value) {
				if (value == null) {
					super.doSetValue(new Integer(-1));
				} else {
					for (int i = 0; i < list.length; i++) {
						if (list[i].equalsIgnoreCase(value.toString())) {
							super.doSetValue(new Integer(i));
						}
					}
				}
			}

			public Object doGetValue() {
				int selection = ((Integer) super.doGetValue()).intValue();
				if (selection == -1) {
					return "";
				} else {
					return list[selection];
				}
			}
		};

		if (getValidator() != null)
			editor.setValidator(getValidator());

		return editor;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null) {
			return value;
		} else if (defaultValue != null) {
			return defaultValue;
		} else {
			return "";
		}
	}

	class MyLabelDecorator extends LabelProvider {
		public Image getImage(Object element) {
			if (element != defaultValue) {
				return ComponentImageRegistry.getSetPropertyImage();
			} else {
				return null;
			}
		}
	}
}
