package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * Descriptor for value of Number(Integer).
 * @author ogawahideko
 *
 */
public class NumberPropertyDescriptor extends TextPropertyDescriptor implements
		IEditorValueDescriptor<Integer> {

	private Integer defaultValue;

	public NumberPropertyDescriptor(Object id, String displayName, Integer defaultValue) {
		super(id, displayName);
		setValidator(new NumberValidator());
		this.defaultValue = defaultValue;
		setLabelProvider(new MyLabelDecorator());
	}

	class NumberValidator implements ICellEditorValidator {
		public String isValid(Object value) {
			if (value != null && value.toString().length() > 0) {
				char[] charArray = value.toString().toCharArray();
				for (int i = 0; i < charArray.length; i++) {
					if (!Character.isDigit(charArray[i])) {
						if (i == 0 && charArray[i] == '-') {
							continue;
						} else {
							return "The input value is not a numerical value. ";
						}
					}
				}
				return null;
			}
			return null;
		}
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new NumberCellEditor(parent);
		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
		return editor;
	}

	class NumberCellEditor extends TextCellEditor {
		NumberCellEditor(Composite parent) {
			super(parent);
		}

		protected void doSetValue(Object value) {
			if (value == null) {
				text.setText("");
			} else {
				Assert.isTrue(text != null && (value instanceof Integer));
				text.setText(String.valueOf(value));
			}
		}

		@Override
		protected Object doGetValue() {
			String value = text.getText();
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return Integer.valueOf(value);
			}
		}
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Integer getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Integer getEditorValue(Integer value) {
		if (value != null) {
			return value;
		} else {
			return defaultValue;
		}
	}

	class MyLabelDecorator extends LabelProvider {
		public Image getImage(Object element) {
			if (element != defaultValue) {
				return ComponentImageRegistry.getSetPropertyImage();
			} else {
				return null;
			}
		}
	}

}
