package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.util.UIUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * <code>PropertyDescriptor</code> for the image property.
 * 
 * @author Naoki Takezoe
 */
public class ImagePropertyDescriptor extends PropertyDescriptor implements
		IEditorValueDescriptor<String> {

	private String defaultValue;

	public ImagePropertyDescriptor(Object id, String displayName, String defaultValue) {
		super(id, displayName);
		this.defaultValue = defaultValue;
	}

	public CellEditor createPropertyEditor(Composite parent) {
		DialogCellEditor cellEditor = new DialogCellEditor(parent) {
			protected Object openDialogBox(Control cellEditorWindow) {
				IEditorPart editorPart = UIUtil.getActiveEditor();
				IFileEditorInput input = (IFileEditorInput) editorPart.getEditorInput();
				IProject project = input.getFile().getProject();

				ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI
						.getWorkbench().getActiveWorkbenchWindow().getShell(),
						new WorkbenchLabelProvider(), new WorkbenchContentProvider());

				dialog.setInput(ResourcesPlugin.getWorkspace());
				dialog.addFilter(new ViewerFilter() {
					public boolean select(Viewer viewer, Object parentElement, Object element) {
						if (element instanceof IProject || element instanceof IFolder) {
							return true;
						}
						if (element instanceof IFile) {
							String name = ((IFile) element).getName();
							if (name.endsWith(".png") || name.endsWith(".gif")
									|| name.endsWith(".jpg") || name.endsWith(".jpeg")) {
								return true;
							}
						}
						return false;
					}
				});
				dialog.setAllowMultiple(false);
				dialog.setTitle("Icon");
				dialog.setInput(project);

				if (dialog.open() == ResourceSelectionDialog.OK) {
					String path = ((IFile) dialog.getResult()[0]).getProjectRelativePath()
							.toString();
					//					if (propertyName == null) {
					return "@Embed('" + path + "')";
					//					} else {
					//						return "@Embed(" + propertyName + "='" + path + "')";
					//					}
				}

				return "";
			}

		};
		return cellEditor;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null) {
			return value;
		} else if (defaultValue != null) {
			return defaultValue;
		} else {
			return "";
		}
	}
}
