package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;
import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;

/**
 * Descriptor for value of Color(RGB).
 * 
 * @author ogawahideko
 */
public class ColorChoosePropertyDescriptor extends ColorPropertyDescriptor implements
		IEditorValueDescriptor<RGB> {

	private RGB defaultValue;

	public ColorChoosePropertyDescriptor(Object id, String displayName, RGB defaultValue) {
		super(id, displayName);
		this.defaultValue = defaultValue;
		setLabelProvider(new MyLabelDecorator());
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public RGB getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public RGB getEditorValue(RGB value) {
		if (value != null) {
			return value;
		} else if (defaultValue != null) {
			return defaultValue;
		} else {
			return null;
		}
	}

	class MyLabelDecorator extends LabelProvider {
		public Image getImage(Object element) {
			if (element != defaultValue) {
				return ComponentImageRegistry.getSetPropertyImage();
			} else {
				return null;
			}
		}

		@Override
		public String getText(Object element) {
			if (element != null && element instanceof RGB) {
				return ColorUtil.toHex((RGB) element);
			} else {
				return super.getText(element);
			}
		}
	}

}
