package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * Descriptor for value of Boolean.
 * 
 * @author ogawahideko
 */
public class BooleanPropertyDescriptor extends PropertyDescriptor implements
		IEditorValueDescriptor<Boolean> {

	private Boolean defaultValue;

	public BooleanPropertyDescriptor(Object id, String displayName, Boolean defaultValue) {
		super(id, displayName);
		this.defaultValue = defaultValue;

		setLabelProvider(new MyLabelDecorator());
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new ComboBoxCellEditor(parent, new String[] { "true", "false" },
				SWT.READ_ONLY) {
			public void doSetValue(Object value) {
				if (((Boolean) value).booleanValue()) {
					super.doSetValue(new Integer(0));
				} else {
					super.doSetValue(new Integer(1));
				}
			}

			public Object doGetValue() {
				int selection = ((Integer) super.doGetValue()).intValue();
				if (selection == 0) {
					return new Boolean(true);
				} else {
					return new Boolean(false);
				}
			}
		};

		if (getValidator() != null)
			editor.setValidator(getValidator());

		return editor;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Boolean getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Boolean getEditorValue(Boolean value) {
		if (value == null) {
			return defaultValue;
		} else {
			return value;
		}
	}

	class MyLabelDecorator extends LabelProvider {
		public Image getImage(Object element) {
			if (element != defaultValue) {
				return ComponentImageRegistry.getSetPropertyImage();
			} else {
				return null;
			}
		}
	}

}
