package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.editparts.AbstractComponentEditPart;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Move down the selected component in the {@link VisualMXMLEditor}.
 * 
 * @author Naoki Takezoe
 */
public class MoveDownAction extends MXMLEditorAction {

	private AbstractComponentModel model;

	public MoveDownAction(VisualMXMLEditor editor) {
		super("Move Down", editor);
	}

	public void run() {
		final AbstractComponentModel execModel = model;
		getCommandStack().execute(new Command() {
			public void execute() {
				execModel.moveDown();
				updateEnable(execModel);
				editor.getMenuFactory().getMoveUpAction().updateEnable(execModel);
			}

			public void undo() {
				execModel.moveUp();
				updateEnable(execModel);
				editor.getMenuFactory().getMoveUpAction().updateEnable(execModel);
			}
		});
	}

	public void update(IStructuredSelection selection) {
		Object obj = selection.getFirstElement();

		if (obj != null && obj instanceof AbstractComponentEditPart) {
			if (((EditPart) obj).getModel() instanceof AbstractComponentModel) {
				updateEnable((AbstractComponentModel) ((EditPart) obj).getModel());
				return;
			}
		}
		setEnabled(false);
		this.model = null;
	}

	public void updateEnable(AbstractComponentModel model) {
		boolean isEnabled = model.isMoveDownEnabled();
		if (isEnabled) {
			setEnabled(isEnabled);
			this.model = model;
			return;
		}

		setEnabled(false);
		this.model = null;
	}

}
