package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.mxml.VisualMXMLEditor;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * The base class for the {@link VisualMXMLEditor}'s context menu actions.
 * 
 * @author Naoki Takezoe
 */
public abstract class MXMLEditorAction extends Action implements IStructuredSelectionRefresh {
	
	protected VisualMXMLEditor editor;
	
	/**
	 * The constructor.
	 * 
	 * @param text the action text
	 * @param editor the VisualMXMLEditor
	 */
	public MXMLEditorAction(String text, VisualMXMLEditor editor){
		super(text);
		this.editor = editor;
	}
	
	public MXMLEditorAction(String text, VisualMXMLEditor editor, int style) {
		super(text, style);
		this.editor = editor;
	}
	
	/**
	 * Returns the GEF command stack of the VisualMXMLEditor.
	 * 
	 * @return the command stack
	 */
	protected CommandStack getCommandStack(){
		return (CommandStack) this.editor.getAdapter(CommandStack.class);
	}
	
	/**
	 * Updates action status such as enabled/disabled.
	 * 
	 * @param selection the selection in the VisualMXMLEditor
	 */
	public abstract void update(IStructuredSelection selection);
	
}
