package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.mxml.editparts.AbstractEditPart;
import net.sf.amateras.air.mxml.editparts.AccordionEditPart;
import net.sf.amateras.air.mxml.editparts.TabNavigatorEditPart;
import net.sf.amateras.air.mxml.editparts.ViewStackEditPart;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Contribution Item for add canvas action.
 * @author ogawahideko
 *
 */
public class AddCanvasContributionItem extends ActionContributionItem implements
		IStructuredSelectionRefresh {

	public AddCanvasContributionItem(IAction action) {
		super(action);
		setVisible(false);
	}

	public void update(IStructuredSelection selection) {
		if (selection.getFirstElement() instanceof TabNavigatorEditPart
				|| selection.getFirstElement() instanceof AccordionEditPart
				|| selection.getFirstElement() instanceof ViewStackEditPart) {
			setVisible(true);
			AbstractContainerModel model = (AbstractContainerModel) ((AbstractEditPart) selection
					.getFirstElement()).getModel();
			((AddCanvasAction) getAction()).setContainerModel(model);

		} else {
			setVisible(false);
			((AddCanvasAction) getAction()).setContainerModel(null);
		}
		update();
	}
}
