package net.sf.amateras.air.mxml;

import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;

/**
 * 
 * @author Naoki Takezoe
 */
public class VisualMXMLEditorContributer extends ActionBarContributor {

	public VisualMXMLEditorContributer() {
		super();
	}
	
	protected void buildActions() {
	    addRetargetAction(new UndoRetargetAction());
	    addRetargetAction(new RedoRetargetAction());
	    addRetargetAction(new DeleteRetargetAction());
//	    addRetargetAction(new ZoomInRetargetAction());
//	    addRetargetAction(new ZoomOutRetargetAction());
	}

	public void setActiveEditor(IEditorPart editor) {
		ActionRegistry registry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
		
	    getActionBars().setGlobalActionHandler(
		    	ActionFactory.PRINT.getId(),
		    	registry.getAction(ActionFactory.PRINT.getId()));
		
	    super.setActiveEditor(editor);
	}
	
	public void contributeToToolBar(IToolBarManager toolBarManager) {
		super.contributeToToolBar(toolBarManager);
//	    toolBarManager.add(getAction(ActionFactory.DELETE.getId()));
//	    toolBarManager.add(getAction(ActionFactory.UNDO.getId()));
//	    toolBarManager.add(getAction(ActionFactory.REDO.getId()));
//	    toolBarManager.add(new Separator());
//	    toolBarManager.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_IN));
//	    toolBarManager.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_OUT));
//	    toolBarManager.add(new ZoomComboContributionItem(getPage()));
	}
	
	protected void declareGlobalActionKeys() {
	}
}
