package net.sf.amateras.air.mxml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.models.AccordionModel;
import net.sf.amateras.air.mxml.models.ApplicationModel;
import net.sf.amateras.air.mxml.models.BoxModel;
import net.sf.amateras.air.mxml.models.ButtonModel;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.CheckBoxModel;
import net.sf.amateras.air.mxml.models.ComboBoxModel;
import net.sf.amateras.air.mxml.models.ControlBarModel;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;
import net.sf.amateras.air.mxml.models.FileSystemComboBoxModel;
import net.sf.amateras.air.mxml.models.FileSystemHistoryButtonModel;
import net.sf.amateras.air.mxml.models.FileSystemListModel;
import net.sf.amateras.air.mxml.models.FileSystemTreeModel;
import net.sf.amateras.air.mxml.models.HBoxModel;
import net.sf.amateras.air.mxml.models.HDividedBoxModel;
import net.sf.amateras.air.mxml.models.HtmlModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.mxml.models.ImageModel;
import net.sf.amateras.air.mxml.models.LabelModel;
import net.sf.amateras.air.mxml.models.ListModel;
import net.sf.amateras.air.mxml.models.PanelModel;
import net.sf.amateras.air.mxml.models.PopUpButtonModel;
import net.sf.amateras.air.mxml.models.RadioButtonModel;
import net.sf.amateras.air.mxml.models.RichTextEditorModel;
import net.sf.amateras.air.mxml.models.RootModel;
import net.sf.amateras.air.mxml.models.SWFLoaderModel;
import net.sf.amateras.air.mxml.models.TabNavigatorModel;
import net.sf.amateras.air.mxml.models.TextAreaModel;
import net.sf.amateras.air.mxml.models.TextInputModel;
import net.sf.amateras.air.mxml.models.TextModel;
import net.sf.amateras.air.mxml.models.TitleWindowModel;
import net.sf.amateras.air.mxml.models.TreeModel;
import net.sf.amateras.air.mxml.models.VBoxModel;
import net.sf.amateras.air.mxml.models.VDividedBoxModel;
import net.sf.amateras.air.mxml.models.VideoDisplayModel;
import net.sf.amateras.air.mxml.models.ViewStackModel;
import net.sf.amateras.air.mxml.models.WindowedApplicationModel;
import net.sf.amateras.air.mxml.parser.AbstractMXMLParser;
import net.sf.amateras.air.mxml.parser.DataGridParser;
import net.sf.amateras.air.mxml.parser.DefaultMXMLParser;
import net.sf.amateras.air.mxml.parser.FileSystemDataGridParser;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Converts MXML to visual models using {@link AbstractMXMLParser}s.
 * 
 * @see DefaultMXMLParser
 * @author Naoki Takezoe
 */
public class MXMLLoader {

	private static Map<String, AbstractMXMLParser> parsers = new HashMap<String, AbstractMXMLParser>();
	static {
		parsers.put("mx:Label", new DefaultMXMLParser(LabelModel.class));
		parsers.put("mx:Text", new DefaultMXMLParser(TextModel.class));
		parsers.put("mx:Button", new DefaultMXMLParser(ButtonModel.class));
		parsers.put("mx:TextArea", new DefaultMXMLParser(TextAreaModel.class));
		parsers.put("mx:TextInput", new DefaultMXMLParser(TextInputModel.class));
		parsers.put("mx:Image", new DefaultMXMLParser(ImageModel.class));
		parsers.put("mx:CheckBox", new DefaultMXMLParser(CheckBoxModel.class));
		parsers.put("mx:ComboBox", new DefaultMXMLParser(ComboBoxModel.class));
		parsers.put("mx:FileSystemComboBox", new DefaultMXMLParser(FileSystemComboBoxModel.class));
		parsers.put("mx:PopUpButton", new DefaultMXMLParser(PopUpButtonModel.class));
		parsers.put("mx:FileSystemHistoryButton", new DefaultMXMLParser(FileSystemHistoryButtonModel.class));
		parsers.put("mx:List", new DefaultMXMLParser(ListModel.class));
		parsers.put("mx:FileSystemList", new DefaultMXMLParser(FileSystemListModel.class));
		parsers.put("mx:DataGrid", new DataGridParser());
		parsers.put("mx:FileSystemDataGrid", new FileSystemDataGridParser());
		parsers.put("mx:RadioButton", new DefaultMXMLParser(RadioButtonModel.class));
		parsers.put("mx:HTML", new DefaultMXMLParser(HtmlModel.class));
		parsers.put("mx:VideoDisplay", new DefaultMXMLParser(VideoDisplayModel.class));
		parsers.put("mx:SWFLoader", new DefaultMXMLParser(SWFLoaderModel.class));
		parsers.put("mx:RichTextEditor", new DefaultMXMLParser(RichTextEditorModel.class));
		parsers.put("mx:Tree", new DefaultMXMLParser(TreeModel.class));
		parsers.put("mx:FileSystemTree", new DefaultMXMLParser(FileSystemTreeModel.class));

		//Layout
		parsers.put("mx:WindowedApplication", new DefaultMXMLParser(WindowedApplicationModel.class));
		parsers.put("mx:Application", new DefaultMXMLParser(ApplicationModel.class));
		parsers.put("mx:TitleWindow", new DefaultMXMLParser(TitleWindowModel.class));
		parsers.put("mx:Box", new DefaultMXMLParser(BoxModel.class));
		parsers.put("mx:VBox", new DefaultMXMLParser(VBoxModel.class));
		parsers.put("mx:HBox", new DefaultMXMLParser(HBoxModel.class));
		parsers.put("mx:HDividedBox", new DefaultMXMLParser(HDividedBoxModel.class));
		parsers.put("mx:VDividedBox", new DefaultMXMLParser(VDividedBoxModel.class));
		parsers.put("mx:ControlBar", new DefaultMXMLParser(ControlBarModel.class));
		parsers.put("mx:Panel", new DefaultMXMLParser(PanelModel.class));
		parsers.put("mx:Accordion", new DefaultMXMLParser(AccordionModel.class));
		parsers.put("mx:Canvas", new DefaultMXMLParser(CanvasModel.class));
		parsers.put("mx:TabNavigator", new DefaultMXMLParser(TabNavigatorModel.class));
		parsers.put("mx:ViewStack",  new DefaultMXMLParser(ViewStackModel.class));

		// out of ui
		parsers.put("mx:DataGridColumn", new DefaultMXMLParser(DataGridColumnModel.class));
	}

	/**
	 * load MXML
	 * @param in
	 * @return
	 */
	public static IContainerModel loadMXML(InputStream in, RootModel root) {
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document doc = builder.parse(in);

			IModel child = parseElement(root, doc.getDocumentElement());
			return (IContainerModel) child;

		} catch (Exception ex) {
			AIRPlugin.logException(ex);
			return new RootModel();
		}
	}

	/**
	 * get parser for elementName.
	 * @param elementName
	 * @return AbstractMXMLParser
	 */
	public static AbstractMXMLParser getParser(String elementName) {
		return (AbstractMXMLParser) parsers.get(elementName);
	}

	/**
	 * parse Element property.
	 * if root is IContainerModel, add child.
	 * @param root
	 * @param e
	 * @return
	 */
	public static IModel parseElement(IModel root, Element e) {
		String elementName = e.getTagName();
		AbstractMXMLParser parser = MXMLLoader.getParser(elementName);

		if (parser != null) {
			ElementWrapper element = new ElementWrapper(e);
			IModel model = null;
			if (root instanceof IContainerModel) {
				model = parser.parse(element, (IContainerModel) root);
				((IContainerModel) root).addChild((IComponentModel) model);
				return model;
			} else {
				model = parser.parse(element, null);
				if (root != null) {
					root.addAdditionalChildElement(e);
				}
				return model;
			}

		} else if (elementName.equals("mx:Script") && root instanceof IContainerModel) {
			String script = e.getAttribute("source");
			if (script != null && script.length() > 0) {
				((IContainerModel) root).addScript(e.getAttribute("source"));
			} else {
				root.addAdditionalChildElement(e);
			}
			return null;
		} else {
			root.addAdditionalChildElement(e);
			return null;
		}
	}

}
