package net.sf.amateras.air.launch;

import java.io.File;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * launch air application.
 * 
 * @author ogawahideko
 *
 */
public class LaunchAIRConfiguration extends LaunchConfigurationDelegate implements
		IDebugEventSetListener {

	public static final String ID = "net.sf.amateras.air.launchAIRConfigurationType";

	public void handleDebugEvents(DebugEvent[] events) {
	}

	@Override
	protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode)
			throws CoreException {
		String projectName = configuration.getAttribute(LaunchAIRMainTab.ATTR_PROJECT, "");
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return new IProject[] { project };
	}

	/**
	 * launch Air Application
	 */
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch,
			IProgressMonitor monitor) throws CoreException {

		String projectName = configuration.getAttribute(LaunchAIRMainTab.ATTR_PROJECT, "");
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);

		// get target descriptor.
		String target;
		boolean isEnableDescriptorEx = LaunchAIRMainTab.isEnableDescriptorEx(configuration);
		if (isEnableDescriptorEx) {
			target = configuration.getAttribute(LaunchAIRMainTab.ATTR_TARGET, "");
		} else {
			target = LaunchAIRMainTab.getProjectDescriptor(project);
		}

		if (new File(target).exists()) {
			target = new File(target).getAbsolutePath();
		} else {
			IFile targetFile = project.getFile(new Path(target));
			target = targetFile.getLocation().toString();
		}

		if (!ProcessUtil.checkAirGearProject(project)) {
			return;
		}

		// get 'sdkPath'
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String adlpath = store.getString(AIRPlugin.PREF_ADL_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(adlpath);

		if (sdkPath == null) {
			return;
		}

		ADLRunner runner = new ADLRunner();
		runner.run(new File(sdkPath, adlpath), new String[] { target }, launch, monitor);
	}

}
