package net.sf.amateras.air.launch;

import java.io.File;
import java.io.IOException;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;

/**
 * A adl runner that launches HTML based AIR applications.
 * 
 * @author Naoki Takezoe
 */
public class ADLRunner {

	public void run(File executeFile, String[] command, ILaunch launch, IProgressMonitor monitor)
			throws CoreException {
		try {
			Process p = ProcessUtil.createProcess(executeFile, command, null);
			//Process p = Runtime.getRuntime().exec(command[0] + " " + command[1]);
			DebugPlugin.newProcess(launch, p, "\"" + executeFile.getName() + " "
					+ new File(command[0]).getName());
		} catch (IOException ex) {
			AIRPlugin.logException(ex);
		}
	}

}
