package net.sf.amateras.air.builder;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.jface.preference.IPreferenceStore;

/**
 * compile property.
 * 
 * @author ogawahideko
 *
 */
public class CompileProperty {
	public static final int MXML_TYPE = 1;
	public static final int AS3_TYPE = 2;
	
	private String directory;
	private int commandType = MXML_TYPE;
	
	private boolean isExtention = false;
	private String command = "";
	private String option = "";
	private List<String> targetFiles = new ArrayList<String>();

	public int getCommandType() {
		return commandType;
	}

	public void setCommandType(int type) {
		this.commandType = type;
	}

	public String getCommand() {
		return command;
	}

	public void setCommand(String command) {
		this.command = command;
	}

	public String getOption() {
		return option;
	}

	public void setOption(String option) {
		this.option = option;
	}

	public String getDirectory() {
		return directory;
	}

	public void setDirectory(String directory) {
		this.directory = directory;
	}
	
	public void addTargetFile(String fileName) {
		targetFiles.add(fileName);
	}
	
	public List<String> getTargetFiles() {
		return targetFiles;
	}

	@Override
	public String toString() {
		return (directory.length() == 0 ? "{ROOT}" : directory) + " / "
				+ (commandType == MXML_TYPE ? "AirFlex" : "ActionScript");
	}

	/**
	 * load from {@link IPreferenceStore}
	 * @param store
	 */
	public static List<CompileProperty> load(IPreferenceStore store) {
		String compiles = store.getString(AIRPlugin.PREF_FLEX_COMPILES);
		List<CompileProperty> result = new ArrayList<CompileProperty>();

		String[] dim = compiles.split("\n");
		for (int i = 0; i < dim.length; i++) {
			String[] com = dim[i].split("\t");
			if (com.length < 5) {
				continue;
			}
			CompileProperty prop = new CompileProperty();
			prop.setDirectory(com[0]);
			prop.setCommand(com[1]);
			prop.setOption(com[2]);
			prop.setCommandType(Integer.parseInt(com[3]));
			prop.setExtention(Boolean.parseBoolean(com[4]));
			result.add(prop);
		}
		return result;

	}

	/**
	 * export to String
	 * @return
	 */
	public static String export(List<CompileProperty> properties) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < properties.size(); i++) {
			CompileProperty prop = properties.get(i);
			sb.append(prop.getDirectory()).append("\t");
			sb.append(prop.getCommand()).append("\t");
			sb.append(prop.getOption()).append("\t");
			sb.append(prop.getCommandType()).append("\t");
			sb.append(prop.isExtention()).append("\t");
			sb.append("\n");
		}
		return sb.toString();
	}

	public boolean isExtention() {
		return isExtention;
	}

	public void setExtention(boolean isExtention) {
		this.isExtention = isExtention;
	}

}
