package net.sf.amateras.air.as;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class ActionScriptPartitionScanner extends RuleBasedPartitionScanner {
	
	public static final String AS_COMMENT = "__as_comment";
	public static final String AS_STRING = "__as_string";

	public ActionScriptPartitionScanner() {
		IPredicateRule[] rules = new IPredicateRule[4];

		IToken comment = new Token(AS_COMMENT);
		rules[0] = new MultiLineRule("/*", "*/", comment, (char) 0, true);
		rules[1] = new EndOfLineRule("//", comment);

		IToken string = new Token(AS_STRING);
		rules[2] = new SingleLineRule("\"", "\"", string, '\\');
		rules[3] = new SingleLineRule("\'", "\'", string, '\\');

		setPredicateRules(rules);
	}
}
