package net.sf.amateras.air;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.ComboBoxModel;
import javax.swing.tree.TreeModel;

import net.sf.amateras.air.mxml.models.AbstractModel;
import net.sf.amateras.air.mxml.models.AccordionModel;
import net.sf.amateras.air.mxml.models.BoxModel;
import net.sf.amateras.air.mxml.models.ButtonModel;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.CheckBoxModel;
import net.sf.amateras.air.mxml.models.ControlBarModel;
import net.sf.amateras.air.mxml.models.DataGridModel;
import net.sf.amateras.air.mxml.models.FileSystemComboBoxModel;
import net.sf.amateras.air.mxml.models.FileSystemDataGridModel;
import net.sf.amateras.air.mxml.models.FileSystemTreeModel;
import net.sf.amateras.air.mxml.models.HBoxModel;
import net.sf.amateras.air.mxml.models.HDividedBoxModel;
import net.sf.amateras.air.mxml.models.HtmlModel;
import net.sf.amateras.air.mxml.models.ImageModel;
import net.sf.amateras.air.mxml.models.LabelModel;
import net.sf.amateras.air.mxml.models.PanelModel;
import net.sf.amateras.air.mxml.models.RadioButtonModel;
import net.sf.amateras.air.mxml.models.RichTextEditorModel;
import net.sf.amateras.air.mxml.models.SWFLoaderModel;
import net.sf.amateras.air.mxml.models.TabNavigatorModel;
import net.sf.amateras.air.mxml.models.TextAreaModel;
import net.sf.amateras.air.mxml.models.TextInputModel;
import net.sf.amateras.air.mxml.models.TextModel;
import net.sf.amateras.air.mxml.models.VBoxModel;
import net.sf.amateras.air.mxml.models.VDividedBoxModel;
import net.sf.amateras.air.mxml.models.VideoDisplayModel;

import org.eclipse.swt.graphics.Image;

/**
 * Manages component images.
 * 
 * @author Naoki Takezoe
 */
public class ComponentImageRegistry {
	
	private static Map<Object, Image> images = new HashMap<Object, Image>();
	
	
	
	/**
	 * Creates <code>Image</code>s.
	 */
	public static void init(){
		images.put(LabelModel.class, AIRPlugin.getImageDescriptor("icons/label.gif").createImage());
		images.put(TextModel.class, AIRPlugin.getImageDescriptor("icons/text.gif").createImage());
		images.put(ImageModel.class, AIRPlugin.getImageDescriptor("icons/image.gif").createImage());
		images.put(ButtonModel.class, AIRPlugin.getImageDescriptor("icons/button.gif").createImage());
		images.put(TextInputModel.class, AIRPlugin.getImageDescriptor("icons/textinput.gif").createImage());
		images.put(TextAreaModel.class, AIRPlugin.getImageDescriptor("icons/textarea.gif").createImage());
		images.put(RichTextEditorModel.class, AIRPlugin.getImageDescriptor("icons/richtext.gif").createImage());
		images.put(CheckBoxModel.class, AIRPlugin.getImageDescriptor("icons/checkbox.gif").createImage());
		images.put(ComboBoxModel.class, AIRPlugin.getImageDescriptor("icons/combobox.gif").createImage());
		images.put(FileSystemComboBoxModel.class, AIRPlugin.getImageDescriptor("icons/combobox.gif").createImage());
		images.put(RadioButtonModel.class, AIRPlugin.getImageDescriptor("icons/radio.gif").createImage());	
		images.put(DataGridModel.class, AIRPlugin.getImageDescriptor("icons/table.gif").createImage());	
		images.put(FileSystemDataGridModel.class, AIRPlugin.getImageDescriptor("icons/table.gif").createImage());	
		images.put(HtmlModel.class, AIRPlugin.getImageDescriptor("icons/html.gif").createImage());	
		images.put(VideoDisplayModel.class, AIRPlugin.getImageDescriptor("icons/video.gif").createImage());
		images.put(SWFLoaderModel.class, AIRPlugin.getImageDescriptor("icons/swf.gif").createImage());	
		
		images.put(BoxModel.class, AIRPlugin.getImageDescriptor("icons/box.gif").createImage());	
		images.put(VBoxModel.class, AIRPlugin.getImageDescriptor("icons/vbox.gif").createImage());
		images.put(HBoxModel.class, AIRPlugin.getImageDescriptor("icons/hbox.gif").createImage());
		images.put(VDividedBoxModel.class, AIRPlugin.getImageDescriptor("icons/vdivided.gif").createImage());
		images.put(HDividedBoxModel.class, AIRPlugin.getImageDescriptor("icons/hdivided.gif").createImage());
		images.put(ControlBarModel.class, AIRPlugin.getImageDescriptor("icons/controlbar.gif").createImage());
		images.put(PanelModel.class, AIRPlugin.getImageDescriptor("icons/panel.gif").createImage());
		images.put(AccordionModel.class, AIRPlugin.getImageDescriptor("icons/accordion.gif").createImage());
		images.put(TabNavigatorModel.class, AIRPlugin.getImageDescriptor("icons/tab.gif").createImage());
		images.put(CanvasModel.class, AIRPlugin.getImageDescriptor("icons/canvas.gif").createImage());
		images.put(TreeModel.class, AIRPlugin.getImageDescriptor("icons/tree.gif").createImage());
		images.put(FileSystemTreeModel.class, AIRPlugin.getImageDescriptor("icons/tree.gif").createImage());
	}
	
	public static Image getSetPropertyImage() {
		return AIRPlugin.getDefault().getImageRegistry().get("SET_PROPERTY_IMAGE");
	}

	
	/**
	 * Disposes <code>Image</code>s.
	 */
	public static void dispose(){
		for(Iterator ite = images.values().iterator(); ite.hasNext();){
			Image image = (Image) ite.next();
			image.dispose();
		}
		images.clear();
	}
	
	/**
	 * Returns <code>Image</code> of the given model.
	 * 
	 * @param model the GEF model
	 * @return <code>Image</code> or <code>null</code>
	 */
	public static Image getImage(AbstractModel model){
		return (Image) images.get(model.getClass());
	}
	
	public static Image getImage(Class clazz) {
		return (Image) images.get(clazz);
	}
}
