package net.sf.amateras.air;

import java.text.MessageFormat;
import java.util.ResourceBundle;

import net.sf.amateras.air.as.EditorColorProvider;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.util.ColorManager;
import net.sf.amateras.air.util.FontManager;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class AIRPlugin extends AbstractUIPlugin {

	/** Preference Key: AIR SDK Path */
	public static final String PREF_AIR_SDK_PATH = "airSdkPath";

	/** Preference Key: Flex SDK Path */
	public static final String PREF_FLEX_SDK_PATH = "flexSdkPath";

	/** Preference Key: Flex Libraries */
	public static final String PREF_FLEX_LIBRARIES = "flexLibraries";

	public static final String PREF_FLEX_COMPILES = "flexCompiles";

	/** Preference Key: fcsh shell command */
	public static final String PREF_FCSH_SHELL_COMMAND = "fcshShellCommand";

	/** Preference Key: adl shell command */
	public static final String PREF_ADL_COMMAND = "adlCommand";

	/** Preference Key: adt shell command */
	public static final String PREF_ADT_COMMAND = "adtCommand";

	/** Preference Key: Flex CompileCommand */
	public static final String PREF_FLEX_COMPILE_COMMAND = "flexCompileCommand";

	public static final String PREF_FLEX_COMPILE_OPTION = "flexCompileCommandOption";

	/** Preference Key: AS3 CompileCommand */
	public static final String PREF_AS3_COMPILE_COMMAND = "as3CompileCommand";

	public static final String PREF_AS3_COMPILE_OPTION = "as3CompileCommandOption";

	/** Prefernce Key: Compile FilPattern */
	public static final String PREF_COMPILE_MESSAGE_PATTERN = "compileMessagePattern";

	public static final String PREF_COMPILE_FAIL_PATTERN = "compileFailPattern";

	public static final String PREF_COMPILE_ERROR_PATTERN = "compileErrorPattern";

	public static final String PREF_COMPILE_WARNING_PATTERN = "compileWarningPattern";

	public static final String PREF_COMPILE_FAIL_PATTERN_2 = "compileFailPattern2";

	public static final String PREF_COMPILE_ERROR_PATTERN_2 = "compileErrorPattern2";

	public static final String PREF_COMPILE_WARNING_PATTERN_2 = "compileWarningPattern2";

	public static final String PREF_IS_ADD_MARKER_COMPILE_INFO = "isAddMarkerCompileInfo";

	/** Preference Key: Application Descriptor */
	public static final String PREF_DESCRIPTOR = "decriptor";

	public static final String PREF_COLOR_DEFAULT = "colorDefault";

	public static final String PREF_COLOR_COMMENT = "colorComment";

	public static final String PREF_COLOR_STRING = "colorString";

	public static final String PREF_COLOR_KEYWORD = "colorKeyword";

	public static final String PREF_FONT_MATTING_SIZE = "fontMattingSize";

	// The plug-in ID
	public static final String PLUGIN_ID = "net.sf.amateras.air";

	// The shared instance
	private static AIRPlugin plugin;

	private EditorColorProvider editorColorProvider;
	private ColorManager colorManager;
	private FontManager fontManager;
	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("airplugin");

	/**
	 * The constructor
	 */
	public AIRPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		editorColorProvider = new EditorColorProvider(getPreferenceStore());
		colorManager = new ColorManager();
		fontManager = new FontManager();
		plugin = this;
		ComponentImageRegistry.init();

		//image
		getImageRegistry().put("SET_PROPERTY_IMAGE",
				AIRPlugin.getImageDescriptor("icons/set_property.gif"));
		getImageRegistry().put("CONTENTS_ASSIST_CLASS",
				AIRPlugin.getImageDescriptor("icons/class.gif"));
		getImageRegistry().put("CONTENTS_ASSIST_PROERTY",
				AIRPlugin.getImageDescriptor("icons/property.gif"));
		getImageRegistry().put("CONTENTS_ASSIST_METHOD",
				AIRPlugin.getImageDescriptor("icons/method.gif"));
		getImageRegistry().put("CONTENTS_ASSIST_INTERFACE",
				AIRPlugin.getImageDescriptor("icons/interface.gif"));
		getImageRegistry().put("CONTENTS_ASSIST_ESERVED_WORD",
				AIRPlugin.getImageDescriptor("icons/reservedword.gif"));

		getImageRegistry().put("SOURCE_FOLDER",
				AIRPlugin.getImageDescriptor("icons/sourcefolder.gif"));

	}

	public ColorManager getColorManager() {
		return this.colorManager;
	}

	public FontManager getFontManager() {
		return this.fontManager;
	}

	public EditorColorProvider getEditorColorProvider() {
		return this.editorColorProvider;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		editorColorProvider.dispose();
		colorManager.dispose();
		fontManager.dispose();
		AirBuilderManager.shutdownCompilers();
		ComponentImageRegistry.dispose();
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static AIRPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public static void logException(Throwable ex) {
		ILog log = getDefault().getLog();
		IStatus status = null;
		if (ex instanceof CoreException) {
			status = ((CoreException) ex).getStatus();
		} else {
			status = new Status(IStatus.ERROR, PLUGIN_ID, 0, ex.toString(), ex);
		}
		log.log(status);

		// TODO Debug
		ex.printStackTrace();
	}

	public static void addNature(IProject project, String natureId) {
		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();
			for (int i = 0; i < natures.length; i++) {
				if (natures[i].equals(natureId)) {
					return;
				}
			}
			String[] newNatures = new String[natures.length + 1];
			System.arraycopy(natures, 0, newNatures, 0, natures.length);
			newNatures[natures.length] = natureId;
			description.setNatureIds(newNatures);
			project.setDescription(description, null);

		} catch (Exception ex) {
			logException(ex);
		}
	}

	public static void removeNature(IProject project, String natureId) {
		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();
			for (int i = 0; i < natures.length; ++i) {
				if (natureId.equals(natures[i])) {
					String[] newNatures = new String[natures.length - 1];
					System.arraycopy(natures, 0, newNatures, 0, i);
					System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
					description.setNatureIds(newNatures);
					project.setDescription(description, null);
					return;
				}
			}
		} catch (Exception ex) {
			logException(ex);
		}

	}

	public static String getResourceString(String key) {
		return RESOURCE_BUNDLE.getString(key);
	}

	public static String getResourceString(String key, Object... args) {
		String value = RESOURCE_BUNDLE.getString(key);
		return MessageFormat.format(value, args);
	}

	public static ResourceBundle getResourceBundle() {
		return RESOURCE_BUNDLE;
	}

}
