package net.java.amateras.xlsbeans;

import java.lang.reflect.Method;

import junit.framework.TestCase;
import jxl.Cell;
import jxl.Workbook;
import jxl.WorkbookSettings;
import net.java.amateras.xlsbeans.xml.AnnotationReader;

public class UtilsTest extends TestCase {

	public void testGetMapColumnMethod() {
		// TODO TestCase
	}

	public void testGetColumnMethod() throws Exception {
		IDE ide = new IDE();
		AnnotationReader reader = new AnnotationReader(null);
		Method[] methods = Utils.getColumnMethod(ide, "IDE", reader);
		assertEquals(1, methods.length);
		assertEquals("setName", methods[0].getName());
	}

	public void testGetCellSheetStringInt1() throws Exception {
		WorkbookSettings settings = new WorkbookSettings();
		settings.setGCDisabled(true);
		Workbook w = Workbook.getWorkbook(
				UtilsTest.class.getResourceAsStream("example_1.xls"), settings);
		
		Cell cell = Utils.getCell(w.getSheet(0), "Title", 0);
		assertEquals("Title", cell.getContents());
	}

	public void testGetCellSheetStringInt2() throws Exception {
		WorkbookSettings settings = new WorkbookSettings();
		settings.setGCDisabled(true);
		Workbook w = Workbook.getWorkbook(
				UtilsTest.class.getResourceAsStream("example_1.xls"), settings);
		
		try {
			Utils.getCell(w.getSheet(0), "Title", 1);
			fail();
		} catch(XLSBeansException ex){
			assertEquals("Cell 'Title' doesn't exist.", ex.getMessage());
		}
	}
	
	public void testInvokeSetter1() throws Exception {
		IDE ide = new IDE();
		Utils.invokeSetter(IDE.class.getMethod("setName", String.class),
				ide, "Eclipse");
		assertEquals("Eclipse", ide.getName());
	}

	public void testInvokeSetter2() throws Exception {
		IDE ide = new IDE();
		try {
			Utils.invokeSetter(IDE.class.getMethod("setVersion", String.class),
					ide, "1.0");
			fail();
		} catch(NoSuchMethodException ex){
			assertEquals(
					"net.java.amateras.xlsbeans.IDE.setVersion(java.lang.String)", 
					ex.getMessage());
		}
	}
	
	public void testGetCellSheetStringCell() {
		// TODO TestCase
	}

	public void testGetCellSheetStringCellBoolean() {
		// TODO TestCase
	}

	public void testGetCellSheetStringCellBooleanBoolean() {
		// TODO TestCase
	}

	public void testGetMethodWithAnnotation() {
		// TODO TestCase
	}

}
