package tk.stepcounter.gui;

import java.util.*;

/**
 * ̑sestatic\bh񋟂NXłB
 *
 * @author  Naoki Takezoe
 * @version 2.0
 */
public class StringUtility {
	
	/*
	// mFpN\bh
	public static void main(String[] args){
		
		
		String i="00";
		
		
		System.out.println("["+StringUtility.cut(i,3)+"]");
		System.out.println("[100]");
	}
	*/
	
	/**
	 * HTML̓LԎQƂɕϊ܂B
	 * sR[h&lt;BR&gt;^Oɕϊ܂B
	 * 
	 * @param str ϊΏۂ̕
	 * @return ϊ̕
	 */
	public static String tagFilter(String str){
		
		str = StringUtility.replace(str,"<","&lt;");
		str = StringUtility.replace(str,">","&gt;");
		str = StringUtility.replace(str,"\"","&quot;");
		str = StringUtility.replace(str,"\r\n","<BR>"); // Win
		str = StringUtility.replace(str,"\r","<BR>");   // Mac
		str = StringUtility.replace(str,"\n","<BR>");   // Unix

		return str;
	}
	
	/**
	 * HTML̓LԎQƂɕϊ܂B
	 * sR[h͕ϊ܂B
	 * tH[ɑli[ۂȂǂɎgpĂB
	 * 
	 * @param str ϊΏۂ̕
	 * @return ϊ̕
	 */
	public static String formFilter(String str){
	
		str = StringUtility.replace(str,"<","&lt;");
		str = StringUtility.replace(str,">","&gt;");
		str = StringUtility.replace(str,"\"","&quot;");
		
		return str;
	}
	
	/**
	 * 񒆂̔Cӂ̕w肵ɒu܂B
	 *
	 * @param s ϊΏۂ̕B
	 * @param s1 s2ɒu镶B
	 * @param s2 s1ɒu镶B
	 * @return ϊ̕Bsnull̏ꍇ͋󕶎Ԃ܂B
	 */
	public static String replace(String s,String s1,String s2){

		// s NULLꍇA󕶎Ԃ
		if(s==null){ return ""; }
		
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<s.length();i++){
			if(s.indexOf(s1,i)==i){
				sb.append(s2);
				i = i + s1.length() - 1;
			} else {
				sb.append(s.charAt(i));
			}
		}
		return sb.toString();
	}
	
	/**
	 * 񂪎w̃oCgZꍇɍXy[XŖ߂܂B
	 * w̃oCgꍇ͂Ȃɂ܂B
	 *
	 * @param str ϊΏۂ̕
	 * @param length oCg
	 * @return ϊ̕
	 */
	public static String fillLeftSpace(String str,int length){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<length-StringUtility.getBytes(str);i++){
			sb.append(" ");
		}
		sb.append(str);
		return sb.toString();
	}
	
	/**
	 * 񂪎w̃oCgZꍇɉEXy[XŖ߂܂B
	 * w̃oCgꍇ͂Ȃɂ܂B
	 *
	 * @param str ϊΏۂ̕
	 * @param length oCg
	 * @return ϊ̕
	 */
	public static String fillRightSpace(String str,int length){
		
		int strLength = StringUtility.getBytes(str);
		if(strLength>=length){ return str; }
		
		String space = StringUtility.createSpace(length-strLength);
		
		return str + space;
	}
	
	/**
	 * 񂪎w̕ioCgł͂Ȃj𒴂ꍇɁA
	 * JbgԂ܂B
	 * w̕菭Ȃꍇ͉ɕԂ܂B
	 *
	 * @param str ϊΏۂ̕
	 * @param length 
	 * @return ϊ̕
	 */
	public static String cut(String str,int length){
		if(str.length() <= length){ return str; }
		return str.substring(0,length);
	}
	
	/**
	 * NULLꍇɋ󕶎ɕϊ܂B
	 *
	 * @param s ϊΏۂ̕B
	 * @return snull̏ꍇ͋󕶎AȊȌꍇ͌̕Ԃ܂B
	 */
	public static String nullConvert(String s){
		if(s==null){ return ""; } else { return s; }
	}

	/**
	 * NULLꍇɎw肵ɕϊ܂B
	 *
	 * @param s ϊΏۂ̕B
	 * @return snull̏ꍇ͎w肵AȊȌꍇ͌̕Ԃ܂B
	 */
	public static String nullConvert(String s1,String s2){
		if(s1==null){ return s1; } else { return s2; }
	}
	

	/**
	 * w肵ŕAzŕԂ܂B
	 *
	 * @param s1 Ώۂ̕B
	 * @param s2 ̋؂Ɏgp镶B
	 * @return ʂzŕԂ܂Bs1null̏ꍇnullԂ܂B
	 */
	public static String[] split(String s1,String s2){
		if(s1 == null){ return null; }
		Vector v  = new Vector();
		String sb = "";
		for(int i=0;i<s1.length();i++){
			if(s1.indexOf(s2,i)==i){
				v.add(sb.toString());
				i = i + s2.length() - 1;
				sb = "";
			} else {
				sb = sb + s1.charAt(i);
			}
		}
		if(sb.length()!=0){ v.add(sb); }
		
		String[] ret = new String[v.size()];
		for(int i=0;i<v.size();i++){
			ret[i] = (String)v.get(i);
		}
		return ret;
	}

	/**
	 * ̃oCgԂ\bhłB
	 *
	 * @param str Ώۂ̕B
	 * @return ̕s̃oCgB
	 */
	public static int getBytes(String str){ return str.getBytes().length; }


	/**
	 * ̐擪Ɩ̃^uAXy[Xr܂BNULL̏ꍇ͋󕶎Ԃ܂B
	 *
	 * @param str B
	 * @return ̕str^uAXy[X菜B
	 */
	public static String trim(String str){
		// NULL̏ꍇA󕶎Ԃ
		if(str==null){ return ""; }

		StringBuffer sb = new StringBuffer();
		for(int i=0;i<str.length();i++){
			char c = str.charAt(i);
			if(c!=' ' && c!='\t' && c!='@'){ sb.append(c); }
		}
		return sb.toString();
	}

	/**
	 * ̖̃^uAXy[Xr܂BNULL̏ꍇ͋󕶎Ԃ܂B
	 *
	 * @param str B
	 * @return ̕str̖^uAXy[X菜B
	 */
	public static String rTrim(String str){
		// NULL̏ꍇA󕶎Ԃ
		if(str==null){ return ""; }
		char c = ' ';
		int index = str.length();
		while((c==' ' || c=='@' || c=='\t') && index > 0){
			index = index - 1;
			c = str.charAt(index);
		}
		return str.substring(0,index+1);
	}

	/**
	 * ̐擪̃^uAXy[Xr܂BNULL̏ꍇ͋󕶎Ԃ܂B
	 *
	 * @param str B
	 * @return ̕str̐擪^uAXy[X菜B
	 */
	public static String lTrim(String str){
		// NULL̏ꍇA󕶎Ԃ
		if(str==null){ return ""; }
		char c = ' ';
		int index = -1;
		while((c==' ' || c=='@' || c=='\t') && index < str.length()){
			index = index + 1;
			c = str.charAt(index);
		}
		return str.substring(index,str.length());
	}

	/**
	 * Xy[X琬w̒̕쐬܂B
	 *
	 * @param num 쐬Xy[X̒B
	 * @return Xy[X琬镶B
	 */
	public static String createSpace(int num){
		if(num <= 0){ return ""; }
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<num;i++){ sb.append(" "); }
		return sb.toString();
	}

	/**
	 * ^z̊evfw肵EgĘA܂B
	 *
	 * @param str A镶^̂PzB
	 * @param del A̋EB
	 * @return AB
	 */
	public static String join(String[] str,String del){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<str.length;i++){
			sb.append(str[i]);
			if(i<str.length-1){ sb.append(del); }
		}
		return sb.toString();
	}
	
	/**
	 * ̉sR[h؂藎ƂԂ܂B
	 * @param str B
	 * @return ̕񂩂疖̉sR[h؂藎ƂB
	 */
	public static String chomp(String str){
		if(str.endsWith("\r\n")){ return str.substring(0,str.length()-2); }
		if(str.endsWith("\r") || str.endsWith("\n")){ return str.substring(0,str.length()-1); }
		return str;
	}
}