//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

#include <xercesc/util/PlatformUtils.hpp>
#include <akaxiso/akaxiso.h>

#include <akaxiso/xerces/parser.h>

namespace {

  class SeqSample : public akaxiso::sequence_impl<SeqSample>{
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("seq_sample");
      define_member("test", &SeqSample::test_);
    }

    short test_;
  };


  class SeqSample1 : public akaxiso::sequence_impl<SeqSample1>{
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("seq_sample1");
      define_member("test", &SeqSample1::test_);
    }
    short test_;
  };


  typedef akaxiso::memberarray_impl<SeqSample> Samples;

  class MemberArraySample : public akaxiso::sequence_impl<MemberArraySample> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("memberarray_sample");
      define_member("sample", &MemberArraySample::samples_);
    }
    Samples samples_;
  };

  class MyDoc : public akaxiso::document_impl<MyDoc, MemberArraySample> {
  public:
    static void initialize_types() {
      define_document("mydoc2");
    }
  };

  void initialize() {
    SeqSample::initialize();
    SeqSample1::initialize();
    MemberArraySample::initialize();
    //    Samples::initialize();
    MyDoc::initialize();
  }

  void uninitialize() {
    SeqSample::uninitialize();
    SeqSample1::uninitialize();
    MemberArraySample::uninitialize();
    MyDoc::uninitialize();
    //Samples::uninitialize();
//     XMLPlatformUtils::Terminate();
  }

}


class MemberArrayTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(MemberArrayTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_appendElement);
  CPPUNIT_TEST(test_appendWrongElement);
  CPPUNIT_TEST(test_equality);
  CPPUNIT_TEST(test_equalityNotEqual1);
  CPPUNIT_TEST(test_equalityNotEqual2);
  CPPUNIT_TEST(test_copy);
  CPPUNIT_TEST(test_replicate); 
  CPPUNIT_TEST(test_serialize);
  CPPUNIT_TEST(test_parse);
//    CPPUNIT_TEST_EXCEPTION(test_occurence, adom::parseexception);
//    CPPUNIT_TEST(test_occurence1);
//    CPPUNIT_TEST_EXCEPTION(test_occurence2, adom::parseexception);
//    CPPUNIT_TEST_EXCEPTION(test_wrongDocument, adom::parseexception);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  MyDoc *doc_;
  MyDoc *doc1_;

public:

  virtual void setUp() {
//     XMLPlatformUtils::Initialize();
    akaxiso::initialize();
    initialize();
    doc_ = NULL;
    doc1_ = NULL;
  }

  virtual void tearDown(){
    if (doc_)
      delete doc_;
    if (doc1_)
      delete doc1_;

    uninitialize();
    akaxiso::uninitialize();
//     XMLPlatformUtils::Terminate();
  }

  static void setValue(MemberArraySample *ma, int numitems) {
    for (int i = 0; i < numitems; ++i) {
      SeqSample *seq = SeqSample::create();
      seq->test_ = 10;
      ma->samples_.push_back(seq);
    }
  }

  static MemberArraySample* createSample(int numitems) {
    MemberArraySample *tks = MemberArraySample::create();
    setValue(tks, numitems);
    return tks;
  }


//CUPPA:decl=+
  void test_appendElement() {
    MemberArraySample *ma = createSample(0);
    SeqSample *seq = SeqSample::create();
//      adom::TokenID tokenid = adom::TokenMap::getTokenID("token"); // Wrong
//      CPPUNIT_ASSERT_MESSAGE("Wrong token", tokenid != adom::TokenMap::INVALID_TOKEN);

    ma->samples_.push_back(seq);
//      adom::Maice::iterator it = tks1->appendElement(tkn, tokenid);

//      CPPUNIT_ASSERT_MESSAGE("Append of element failed.", it != tks1->end());
//      delete tkn;
//      delete tks1;

    delete ma;
  }

  void test_appendWrongElement() {
    MemberArraySample *ma1 = createSample(0);
    SeqSample1 *seq = SeqSample1::create();


    bool exception_caught = false;
    try {
      ma1->samples_.memberarray::push_back(seq);
    }
    catch (...) {
      exception_caught = true;
    }

    delete ma1;
    delete seq;

    CPPUNIT_ASSERT_MESSAGE("Append of wrong element unexpectedly-succeeded.", exception_caught);
  }


  void test_equality() {
    MemberArraySample *ma1 = createSample(10);
    MemberArraySample *ma2 = createSample(10);
    bool isEqual = ma1->is_equal_to(ma2);
    delete ma1;
    delete ma2;

    CPPUNIT_ASSERT_MESSAGE("is_equal_to() failed.", isEqual);
  }

  void test_equalityNotEqual1() {
    MemberArraySample *ma1 = createSample(10);
    MemberArraySample *ma2 = createSample(9);
    bool isEqual = ma1->is_equal_to(ma2);
    delete ma1;
    delete ma2;

    CPPUNIT_ASSERT_MESSAGE("isEqualTo failed.", !isEqual);
  }

  void test_equalityNotEqual2() {
    MemberArraySample *ma1 = createSample(10);
    MemberArraySample *ma2 = createSample(10);

    Samples::iterator it = ma1->samples_.begin();
    it->test_ = 1000;

    bool isEqual = ma1->is_equal_to(ma2);
    delete ma1;
    delete ma2;

    CPPUNIT_ASSERT_MESSAGE("isEqualTo failed.", !isEqual);
  }


  void test_copy() {
    MemberArraySample *ma1 = createSample(10);
    MemberArraySample *ma2 = createSample(0);
    ma1->copy_to(ma2);
    bool isEqual = ma1->is_equal_to(ma2);
    delete ma1;
    delete ma2;

    CPPUNIT_ASSERT_MESSAGE("isEqualTo failed.", isEqual);
  }

  void test_replicate() {
    MemberArraySample *ma1 = createSample(10);
    MemberArraySample *ma2 = ma1->replicate();
    bool isEqual = ma1->is_equal_to(ma2);
    delete ma1;
    delete ma2;

    CPPUNIT_ASSERT_MESSAGE("isEqualTo failed.", isEqual);
  }

  void test_serialize() {
    doc_ = MyDoc::create();
    SeqSample *seq = SeqSample::create();
    doc_->get_root()->samples_.push_back(seq);
    seq->test_ = 0;
    
    std::ostringstream ostm;
    akaxiso::xmlserializer ser;

    ser.serialize(doc_, ostm);

//     std::cout << ostm.str();
  }

  void test_parse() {
    doc_ = MyDoc::create();

    setValue(doc_->get_root(), 10);
    
    std::ostringstream ostm;
    akaxiso::xmlserializer ser;
    ser.serialize(doc_, ostm);

//     std::cerr << ostm.rdbuf()->str() << std::endl;

    akaxiso::yggxml_parser parser;
    doc1_ = static_cast<MyDoc*>(parser.parse(ostm.rdbuf()->str()));

    bool is_equal = doc_->get_root()->is_equal_to(doc1_->get_root());

    if (!is_equal) {
      if (doc1_)
      ser.serialize(doc1_, ostm);
      std::cout << ostm.rdbuf()->str();
    }

    CPPUNIT_ASSERT_MESSAGE("isEqualTo Failed.", is_equal);
   }

//    void test_occurence() {
//      doc_ = MyDoc::createInstance();
    
//      setValue(doc_->getDocumentElement(), 30);

//      adom::ostringstream ostm;
//      adom::XMLSerializer ser;
//      ser.serialize(doc_, ostm);

//      adom::XMLParser parser;

//      // Must throw excetption.
//      doc1_ = static_cast<MyDoc*>(parser.parse(ostm.rdbuf()->str()));
//    }


//    void test_occurence1() {
//      doc_ = MyDoc::createInstance();

//      setValue(doc_->getDocumentElement(), 25);

//      adom::ostringstream ostm;
//      adom::XMLSerializer ser;
//      ser.serialize(doc_, ostm);

//      adom::XMLParser parser;

//      // Must NOT throw excetption.
//      doc1_ = static_cast<MyDoc*>(parser.parse(ostm.rdbuf()->str()));
//    }


//    void test_occurence2() {
//      doc_ = MyDoc::createInstance();

//      adom::ostringstream ostm;
//      adom::XMLSerializer ser;
//      ser.serialize(doc_, ostm);

//      adom::XMLParser parser;

//      // Must NOT throw excetption.
//      doc1_ = static_cast<MyDoc*>(parser.parse(ostm.rdbuf()->str()));
//    }

//    void test_wrongDocument() {
//      adom::string doc =
//        "<?xml version=\"1.0\"?>"
//        "<mydoc>"
//        "  <dummytoken>token</dummytoken>"
//        "</mydoc>";

//      adom::XMLParser parser;
//      doc_ = static_cast<MyDoc*>(parser.parse(doc));
//    }

//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(MemberArrayTest);
