#include "schemastructure.h"

using namespace xml_schema;

void maxOccurs_type::write_text(std::ostream &ostm, const akaxiso::global_attributes &gattrs) const {
  if (value_ == akaxiso::unbounded)
    ostm << "unbounded";
  else
    ostm << value_;
}

bool maxOccurs_type::read_text(std::istringstream &istm, const akaxiso::global_attributes &gattrs) {

  if (istm.rdbuf()->str() == "unbounded") {
    value_ = akaxiso::unbounded;
    return true;
  }

  istm >> value_;
  return !istm.fail();
}


void xml_schema::initialize() {
  akaxiso::initialize_namespace<xsd>();
  GlobalElement::initialize();
  Element::initialize();
  Attribute::initialize();
  Sequence::initialize();
  Choice::initialize();
  ComplexType::initialize();
  Schema::initialize();
  SchemaDoc::initialize();
}

void xml_schema::uninitialize(){
  GlobalElement::uninitialize();
  Element::uninitialize();
  Attribute::uninitialize();
  Sequence::uninitialize();
  Choice::uninitialize();
  ComplexType::uninitialize();
  Schema::uninitialize();
  SchemaDoc::uninitialize();
}


bool name::read_text(std::istringstream &istm, const akaxiso::global_attributes &gattrs) {
  const std::string &rawname = istm.rdbuf()->str();
  set_name(rawname, gattrs);
  return true;
}

void name::write_text(std::ostream &ostm, const akaxiso::global_attributes &gattrs) const {
  ostm << get_name();
}
