#include "parser.h"
#include "xerces_handler.h"
#include <assert.h>
using namespace akaxiso;

#ifndef USE_XERCESC

xerces_parser::xerces_parser() {
  assert(!"Configuration does not include the use of Xerces-c");
}


#else

#include <xercesc/framework/MemBufInputSource.hpp>
#include <xercesc/framework/StdInInputSource.hpp>
#include <xercesc/sax2/SAX2XMLReader.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>



xerces_parser::xerces_parser() {}


xerces_parser::~xerces_parser() { 
}


document *xerces_parser::parse_stdin(){
  xercesc::StdInInputSource is;
  return parse(is);
}



document *xerces_parser::parse(const char *buff){

  char *membuf_id = "(document on memory)";
  xercesc::MemBufInputSource membuf_is( reinterpret_cast<const XMLByte*>(buff),
					strlen(buff),
					membuf_id,
					false);
  return parse(membuf_is);
  
}


document *xerces_parser::parse(const std::string& document){

  char *membuf_id = "(document on memory)";
  xercesc::MemBufInputSource membuf_is( reinterpret_cast<const XMLByte*>(document.c_str()),
					document.length(),
					membuf_id,
					false);
  return parse(membuf_is);
  
}



document *xerces_parser::parse(xercesc::InputSource &is) {
  
  bool do_namespaces = true;
  bool do_namespace_prefixes = false;
  bool do_schema = false;
  bool full_checking = false;
  xercesc::SAX2XMLReader::ValSchemes valschemes = xercesc::SAX2XMLReader::Val_Auto;

  xerces_handler *handler = new xerces_handler();

  xercesc::SAX2XMLReader* parser = xercesc::XMLReaderFactory::createXMLReader();
  parser->setFeature(xercesc::XMLUni::fgSAX2CoreNameSpaces, do_namespaces);
  parser->setFeature(xercesc::XMLUni::fgSAX2CoreNameSpacePrefixes, do_namespace_prefixes);

  parser->setFeature(xercesc::XMLUni::fgXercesSchema, do_schema);
  parser->setFeature(xercesc::XMLUni::fgXercesSchemaFullChecking, full_checking);

  if (valschemes == xercesc::SAX2XMLReader::Val_Auto)  {
      parser->setFeature(xercesc::XMLUni::fgSAX2CoreValidation, true);
      parser->setFeature(xercesc::XMLUni::fgXercesDynamic, true);
  }
  if (valschemes == xercesc::SAX2XMLReader::Val_Never)  {
      parser->setFeature(xercesc::XMLUni::fgSAX2CoreValidation, false);
  }
  if (valschemes == xercesc::SAX2XMLReader::Val_Always)  {
      parser->setFeature(xercesc::XMLUni::fgSAX2CoreValidation, true);
      parser->setFeature(xercesc::XMLUni::fgXercesDynamic, false);
  }


  parser->setContentHandler(handler);
  parser->setErrorHandler(handler);
  
  parser->parse(is);
  
  document *doc = handler->adopt_document();
  delete handler;
  return doc;
}

#endif
