// -*- c++ -*-
#ifndef AKAXISO_SOX_SERIALIZER_H__
#define AKAXISO_SOX_SERIALIZER_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/classes.h>
#include <akaxiso/serializer.h>

namespace akaxiso {
  
  class soxserializer : public serializer {
  public:
    soxserializer(const std::string &encoding = "UTF-8") : encoding_(encoding){};
    virtual void serialize(const document *doc, std::ostream &ostm);
  private:
    void write_element(const element *element, const std::string &tagname, std::ostream &ostm);
    void write_element_tag(const std::string &tagname, std::ostream &ostm);
    void write_entity(const element* e, std::ostream &ostm);

    void write_namespace_attributes(std::ostream &ostm);


    std::string encoding_;
    int indent_;
  };

}


#endif




