// -*- c++ -*-
#ifndef AKAXISO_SIMPLECONTENT_HANDLER_H__
#define AKAXISO_SIMPLECONTENT_HANDLER_H__

#include <akaxiso/parser/handler.h>

namespace akaxiso {
  class simplecontent;
  
  class simplecontent_handler : public handler {
  public:
    simplecontent_handler(simplecontent *sim, handlers &handlers, const locator *locator);
    virtual ~simplecontent_handler(){}
    virtual void query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void end_element(const name &qname);
    virtual void parse_entity(const std::string &entity);
    virtual bool rollup() const;


    virtual element *get_element();
    virtual void receive_child(element *e);

  private:
    simplecontent *sim_;
    const global_attributes *gattrs_;
  };

}

#endif

