// -*- c++ -*- 
#ifndef CDOM_SEQUENCE_HANDLER_H__
#define CDOM_SEQUENCE_HANDLER_H__

#include <akaxiso/parser/handler.h>
#include <akaxiso/classes/sequence.h>

namespace akaxiso {

  class sequence_handler : public handler {
  public:
    sequence_handler(sequence *seq, handlers &handlers, const locator *locator);
    virtual ~sequence_handler(){}
    virtual void query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void end_element(const name &qname);
    virtual void parse_entity(const std::string &entity);
    virtual bool rollup() const;

    virtual element* get_element();
    virtual void receive_child(element *e);

  private:
    void inc_member_for_memberinfo();
    void inc_member_for_memberinfo_till_end();

    sequence *seq_;
    const sequence_info &info_;
    sequence_info::const_iterator it_;
  };

}


#endif
