#include "sequence_handler.h"

#include "choice_handler.h"
#include "simpletype_handler.h"
#include "simplecontent_handler.h"
#include "memberarray_handler.h"
#include "../classes/membertypes.h"
#include "../classes/choice.h"
#include "../classes/simplecontent.h"
#include "../classes/memberarray.h"

#include <cassert>



using namespace akaxiso;


sequence_handler::sequence_handler(sequence *seq, handlers &handlers, const locator *locator)  
  : handler(handlers, locator) , seq_(seq), info_(seq->get_sequence_info())  {
  it_ = info_.begin();
}

void sequence_handler::query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs){
  if (it_ == info_.end())
    throw parse_exception(__FILE__, __LINE__, locator_->get_position());

  while (true) {
    if (it_->get_qname() == qname)
      break;

    if (it_->get_member_operator().get_baseclass_id() != memberarray_id)
      throw parse_exception(__FILE__, __LINE__, locator_->get_position());

    ++it_;

    if (it_ == info_.end())
      throw parse_exception(__FILE__, __LINE__, locator_->get_position());

  }

  const member_operator &op = it_->get_member_operator(); 

  if (it_->get_qname() != qname)
    throw parse_exception(__FILE__, __LINE__, locator_->get_position());

  // Branch according to the member type.

  handler *handler = NULL;

  switch (op.get_baseclass_id()) {
  case sequence_id: {
    const element_member_type &etype = static_cast<const element_member_type&>(op);
    element *member_e = etype.get_member_element(*seq_);
    handler = new sequence_handler(static_cast<sequence*>(member_e), handlers_, locator_);
    handlers_.push(handler);
    ++it_;
    break;
  }
  case choice_id: {
    const element_member_type &etype = static_cast<const element_member_type&>(op);
    element *member_e = etype.get_member_element(*seq_);
    handler = new choice_handler(static_cast<choice*>(member_e), handlers_, locator_);
    handlers_.push(handler);
    ++it_;
    break;
  }
  case simpletype_id: {
    const simpletype_member_type &smt = static_cast<const simpletype_member_type &>(op);
    handler = new simpletype_handler(seq_, smt, handlers_, locator_);
    handlers_.push(handler);
    ++it_;
    break;
  }
  case simplecontent_id: {
    const element_member_type &etype = static_cast<const element_member_type &>(op);
    element *member_e = etype.get_member_element(*seq_);
    handler = new simplecontent_handler(static_cast<simplecontent*>(member_e), handlers_, locator_);
    handlers_.push(handler);
    ++it_;
    break;
  }
  case memberarray_id: {
    const memberarray_member_type &mtype = static_cast<const memberarray_member_type &>(op);
    memberarray *ma = mtype.get_memberarray(*seq_);
    handler = new memberarray_handler(ma, *it_, handlers_, locator_);
    handlers_.push(handler);
    handler->query_element(qname, attrs, gattrs);
    break;
  }
  default:
    assert(!"Internal error.  Must not reach here.");
  }
  
  
}

void sequence_handler::prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs){
}


void sequence_handler::end_element(const name &qname){
  inc_member_for_memberinfo_till_end();
  if (it_ != info_.end())
    throw parse_exception(__FILE__, __LINE__, locator_->get_position());
}


void sequence_handler::parse_entity(const std::string &entity) {
  
}


element *sequence_handler::get_element() {
  return seq_;
}

void sequence_handler::receive_child(element *e) {
  
}

bool sequence_handler::rollup() const {
  return false;
}

void sequence_handler::inc_member_for_memberinfo() {
  if (it_ != info_.end()) {
    const member_operator *op = &it_->get_member_operator();
    if (op->get_baseclass_id() == memberarray_id)
      ++it_;
  }
}


void sequence_handler::inc_member_for_memberinfo_till_end() {
  while (it_ != info_.end()) {
    const member_operator *op = &it_->get_member_operator();
    if (op->get_baseclass_id() == memberarray_id)
      ++it_;
    else 
      break;
  }
}
