#include "document_handler.h"

#include "../classes/name.h"
#include "../parser/attributes.h"
#include "../classes/document.h"

#include "sequence_handler.h"
#include "choice_handler.h"
#include "simplecontent_handler.h"

#include "../classes/choice.h"
#include "../classes/sequence.h"
#include "../classes/simplecontent.h"

#include "attribute_handler.h"


using namespace akaxiso;

document_handler::document_handler() : doc_(NULL), locator_(NULL) {
  locator_ = new locator();
}

document_handler::~document_handler() {
  if (doc_)
    delete doc_;
  delete locator_;
}


void document_handler::startElement(const name &tagname , const attributes& attrs) {

  charsbuf_.resize(0);

  if (handlers_.empty()) {
    doc_ = document_factory::create_named_document(tagname);
    element *root = doc_->get_root_element();

    handler *handler = NULL;

    switch (root->get_baseclass_id()) {
    case sequence_id:
      handler = new sequence_handler(static_cast<sequence*>(root), handlers_, locator_);
      break;
    case choice_id: 
      handler = new choice_handler(static_cast<choice*>(root), handlers_, locator_);
      break;
    case simplecontent_id:
      handler = new simplecontent_handler(static_cast<simplecontent*>(root), handlers_, locator_);
      break;
    case memberarray_id:
    case simpletype_id:
      throw internal_error();
    }
    
    handlers_.push(handler);
    parse_attributes(*root, attrs, gattrs_);
    return;
  }

  handler *handler = handlers_.top();
  handler->query_element(tagname, attrs, gattrs_);
  handler = handlers_.top();
  if (handler->get_element())
    parse_attributes(*handler->get_element(), attrs, gattrs_);
  else
    parse_exception(__FILE__, __LINE__, "??");
}

void document_handler::endElement(const name &tagname){

  handler *handler = handlers_.top();
  handler->parse_entity(charsbuf_);

  while (true) {
    handler = handlers_.top();
    handler->end_element(tagname);
    handlers_.pop();
    if (!handlers_.empty())
      handlers_.top()->receive_child(handler->get_element());
    delete handler;
    if (handlers_.empty())
      break;
    if (!handlers_.top()->rollup())
      break;
  };
}

void document_handler::characters(const   char*     chars, 
				  const unsigned int    length){
  charsbuf_ += std::string(chars, length);
}

document *document_handler::adopt_document(){
  document *doc = doc_;
  doc_ = NULL;
  return doc;
}


void document_handler::set_locator(const locator* locator) {
  delete locator_;
  locator_ = locator;
}

void document_handler::start_prefix_mapping(const std::string &prefix, const std::string &uri) {
  gattrs_.associate_namespace_prefix(prefix, uri);
}

void document_handler::end_prefix_mapping(const std::string &prefix) {
  gattrs_.clear_namespace_prefix(prefix);
}

