// -*- c++ -*-
#ifndef AKAXISO_SEQUENCE_IMPL_H__
#define AKAXISO_SEQUENCE_IMPL_H__

#include <akaxiso/classes/sequence.h>
#include <akaxiso/classes/membertypes.h>
#include <akaxiso/classes/simpletype.h>
#include <akaxiso/classes/base_impl.h>

namespace akaxiso {

  template<class T>
  class sequence_impl : public sequence, public base_impl<T>  {
  protected:
    typedef T finalclass;
  public:
    virtual bool is_equal_to(const element *element) const;
    virtual void copy_to(element *element) const;
    virtual const typeinfo &get_typeinfo() const;
    virtual element *replicate_element() const;

    virtual const sequence_info& get_sequence_info() const;
    virtual const attribute_info &get_attribute_info() const;

    T *replicate() const;

    static void initialize();
    static void uninitialize();
    static T* create();

    struct define_member {
      template<class P, class V> 
      define_member(const char *tagname, V P::* member) {
	      op_ = akaxiso::create_member_operator(reinterpret_cast<T*>(0), member);
	      member_info meminfo = akaxiso::member_info(op_); 
	      meminfo.set_name(tagname); 
	      T::static_sequence_info().register_memberinfo(meminfo);
      }
      void set_default_value(const char *defval) {
	if (op_->get_baseclass_id() != simpletype_id){
	  throw internal_error();
	}
	akaxiso::simpletype_member_type *simtype = static_cast<akaxiso::simpletype_member_type*>(op_); 
	simtype->set_default_value(defval);
      };
      member_operator *op_;
    };

    static sequence_info &static_sequence_info() { return sequence_info_; }
    static attribute_info &static_attribute_info() { return attribute_info_; }
  protected:
    static typeinfo &static_typeinfo(){ return typeinfo_; }
    static sequence_info sequence_info_;
  };

  template<class T>
  sequence_info sequence_impl<T>::sequence_info_;



  template<class T>
  const sequence_info &sequence_impl<T>::get_sequence_info() const {
    return sequence_info_;
  }

  template<class T>
  const attribute_info &sequence_impl<T>::get_attribute_info() const {
    return attribute_info_;
  }


  template<class T>
  const typeinfo &sequence_impl<T>::get_typeinfo() const {
    return typeinfo_;
  }

  template<class T>
  T* sequence_impl<T>::replicate() const {
    T* t = create();
    copy_to(t);
    return t;
  }

  template<class T>
  bool sequence_impl<T>::is_equal_to(const element *element) const {
    if (& get_typeinfo() != & element->get_typeinfo())
      return false;
    const T* t = static_cast<const T*>(element);
    if (!sequence_info_.is_equal(*this, *t))
      return false;
    return attribute_info_.is_equal(*this, *t);
  }  

  template<class T>
  void sequence_impl<T>::copy_to(element *element) const {
    if (& get_typeinfo() != & element->get_typeinfo())
      throw invalid_argument();
    T* t = static_cast<T*>(element);
    sequence_info_.copy(*t, *this);
    attribute_info_.copy(*t, *this);
  }  

  template<class T>
  void sequence_impl<T>::initialize() {
    sequence_info_.clear();
//      T::register_to_factory();
    T::initialize_types();
  }
  
  template<class T>
  void sequence_impl<T>::uninitialize() {
    sequence_info_.clear();
    attribute_info_.clear();
  }

  template<class T>
  T* sequence_impl<T>::create() {
    T* t = new T;
    sequence_info_.initialize_instance(*t);
    attribute_info_.initialize_instance(*t);
    return t;
  }

  template<class T>
  element *sequence_impl<T>::replicate_element() const {
    return replicate();
  }


  template<class T>
  class sequence_member_type_impl : public element_member_type {
  public:
    sequence_member_type_impl(int offset) : element_member_type(offset) {}
    virtual bool is_equal(const element &seq1, const element &seq2) const;
    virtual void copy(element &dst, const element &src) const;
    virtual void initialize_instance(element &seq) const;
    virtual baseclass_id get_baseclass_id() const;
  };

  template<class T>
  bool sequence_member_type_impl<T>::is_equal(const element &seq1, const element &seq2) const {
    const T* t1 = get_member_ptr<const T>(seq1, offset_);
    const T* t2 = get_member_ptr<const T>(seq2, offset_);
    return t1->is_equal_to(t2);
  }

  template<class T>
  void sequence_member_type_impl<T>::copy(element &dst, const element &src) const {
    T* tdst = get_member_ptr<T>(dst, offset_);
    const T* tsrc = get_member_ptr<const T>(src, offset_);
    tsrc->copy_to(tdst);
  } 

  template<class T>
  void sequence_member_type_impl<T>::initialize_instance(element &element) const {
    T& tdst = *get_member_ptr<T>(element, offset_);
    T::static_sequence_info().initialize_instance(tdst);
    T::static_attribute_info().initialize_instance(tdst);
  }

  template<class T>
  baseclass_id sequence_member_type_impl<T>::get_baseclass_id() const {
    return sequence_id;
  }

}

#endif
