/* -*- c++ -*- */
#ifndef AKAXISO_NAME_H__
#define AKAXISO_NAME_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/global_attributes.h>

namespace akaxiso {

  class name {
  public:
    friend struct name_less;
    name() : uri_id_(empty_token){}
    void set_name(const std::string &uri, const std::string &name);
    void set_name(const std::string &rawname);
    void set_name(const std::string &rawname, const global_attributes &gattr);
    void set_localname(const std::string &name);
    const std::string &get_name() const;
    const std::string &get_localname() const;
    const id_type get_uri_id() const { return uri_id_; }
    bool operator==(const name &rhs) const {  return (uri_id_ == rhs.uri_id_) && (name_ == rhs.name_); }
    bool operator!=(const name &rhs) const {  return (uri_id_ != rhs.uri_id_) || (name_ != rhs.name_); };
    bool empty() const;

  private:
    bool is_qualified() const { 
      return uri_id_ != empty_token; 
    }
    id_type uri_id_;
    std::string name_;
    mutable std::string cache_;
  };

  struct name_less  : std::binary_function<const name, const name, bool>{

    bool operator()(const name &lhs, const name &rhs) const {
      if (lhs.uri_id_ < rhs.uri_id_)
	return true;
      else if (lhs.uri_id_ == rhs.uri_id_)
	return (lhs.name_ < rhs.name_);
      return false;
    }

  };

}

#endif
