/* -*- c++ -*- */
#ifndef AKAXISO_VALUETYPE_H__
#define AKAXISO_VALUETYPE_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/element.h>
#include <akaxiso/classes/namespaces.h>

namespace akaxiso {

  class memberarray;


  // For members.

  struct text_marshaller {
    virtual ~text_marshaller() {} 
    virtual void write_text(const element &, 
			    std::ostream &ostm, 
			    const global_attributes &gattrs) const = 0;
    virtual void read_text(element &, std::istringstream &istm, const global_attributes &gattrs) const = 0;
  };

  struct member_element_getter {
    virtual ~member_element_getter() {}
    virtual element* get_member_element(element &element) const = 0;
    virtual const element* get_member_element(const element &element) const = 0;
  };

  struct memberarray_getter {
    virtual ~memberarray_getter(){}
    virtual memberarray *get_memberarray(element &element) const = 0;
    virtual const memberarray *get_memberarray(const element &element) const = 0;
  };

  struct default_value {
    virtual ~default_value() {}
    virtual void set_default_value(const char *defval) = 0;
    virtual bool is_default(const element &element) const = 0;
  };

  struct member_operator {
    virtual ~member_operator() {}
    virtual bool is_equal(const element &element1, const element &element2) const = 0;
    virtual void copy(element &dst, const element &src) const = 0;
    virtual void initialize_instance(element &element) const = 0;
    virtual baseclass_id get_baseclass_id() const = 0;
  };


  struct simpletype_member_type : public text_marshaller,
				  public member_operator,
				  public default_value {
    virtual ~simpletype_member_type() {}
  };


  struct element_member_type : public member_element_getter,
			       public member_operator {
    element_member_type(int offset) : offset_(offset){}
    virtual ~element_member_type(){}
    virtual element* get_member_element(element &element) const;
    virtual const element* get_member_element(const element &element) const;
  protected:
    int offset_;
  };


  struct simplecontent_member_type : public element_member_type {
    simplecontent_member_type(int offset) : element_member_type(offset){}
    virtual ~simplecontent_member_type(){}
  };

  
  
  struct memberarray_member_type : public member_operator,
				   public memberarray_getter {
    memberarray_member_type(int offset) : offset_(offset) {}
    virtual ~memberarray_member_type() {} 
  protected:
    int offset_;
  };

  

  template<class V>
  V* get_member_ptr(const element &element, int offset) {
    return reinterpret_cast<V*>(reinterpret_cast<int>(&element) + offset);
  }

  template <class P, class T, class V>
  int get_member_offset(V T::* member) {
    P* p = reinterpret_cast<P*>(1024);
    return reinterpret_cast<int>(& (p->*member)) - reinterpret_cast<int>(p);
  }




}

#endif
