// -*- c++ -*-
#ifndef AKAXISO_MEMBERINFO_H__
#define AKAXISO_MEMBERINFO_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/name.h>

namespace akaxiso {
  struct member_operator;

  class member_info {
  public:
    member_info(){}
    member_info(member_operator *op) : op_(op){}
    void clear();

    void set_name(const std::string &name){
      name_.set_name(name);
    }
    
    const name &get_qname() const;
    const std::string &get_tagname() const;
    const std::string &get_localname() const;

    const member_operator &get_member_operator() const;

  private:
    name name_;
    member_operator *op_;
  };
}


#endif
