/* -*- c++ -*- */
#ifndef AKAXISO_GLOBAL_ATTRIBUTES_H__
#define AKAXISO_GLOBAL_ATTRIBUTES_H__

#include <akaxiso/classes/namespace_map.h>

namespace akaxiso {

  struct xmllang {
    std::string langname_;
    int depth_;
  };

  class global_attributes {
  public:
    void initialize();
    void uninitialize();

    void associate_namespace_prefix(const std::string &prefix, const std::string &uri);
    void clear_namespace_prefix(const std::string &prefix);
    const prefix_map &get_prefix_map() const {
      return prefixes_;
    }
    // XML global attributes.
    // xsi:space will be stored.
    
    //     const std::string &get_lang() const;
  private:
    // Namespace association
    prefix_map prefixes_;

    xmllang lang_;
  };

}

#endif
