/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.util;

import java.math.BigDecimal;

public class Calc {
    public static final BigDecimal HOUR = Calc.div(BigDecimal.ONE, 24L);
    public static final BigDecimal MIN = Calc.div(HOUR, 60L);
    public static final BigDecimal SEC = Calc.div(MIN, 60L);
    public static final BigDecimal MSEC = Calc.div(SEC, 1000L);
    public static final BigDecimal JP_H = new BigDecimal("0.375");
    public static final BigDecimal J86400 = new BigDecimal("86400.00000000000000000000");

    public static long up(BigDecimal d) {
        return d.setScale(0, 0).longValue();
    }

    public static long cut(BigDecimal d) {
        return d.setScale(0, 1).longValue();
    }

    public static long half(BigDecimal d) {
        return d.setScale(0, 4).longValue();
    }

    public static BigDecimal div(BigDecimal a, BigDecimal b) {
        return a.divide(b, 30, 4);
    }

    public static BigDecimal div(BigDecimal a, long b) {
        return Calc.div(a, new BigDecimal(b));
    }

    public static BigDecimal mul(BigDecimal a, long b) {
        return a.multiply(new BigDecimal(b));
    }

    public static BigDecimal cos(BigDecimal r) {
        return new BigDecimal(Double.toString(Math.cos(r.doubleValue() * 3.1415926535 / 180.0)));
    }

    public static String toString(BigDecimal b) {
        int len;
        String org = b.toPlainString();
        char[] str = org.toCharArray();
        boolean flag = false;
        for (int i = str.length - 1; i >= 0; --i) {
            if (str[i] == '.') {
                flag = true;
                str[i] = 32;
                break;
            }
            if (str[i] != '0') break;
            str[i] = 32;
        }
        for (len = 0; len < str.length && str[len] != ' '; ++len) {
            if (str[len] != '.') continue;
            flag = true;
        }
        return flag ? new String(str, 0, len) : org;
    }
}

