/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery;

import ajd4jp.AJDException;
import ajd4jp.orrery.Angle;
import ajd4jp.orrery.ETD;
import ajd4jp.orrery.Planet;
import ajd4jp.orrery.Pole;
import java.io.IOException;

public enum Zodiac {
    ARIES(30, "\u767d\u7f8a\u5bae", "\u7261\u7f8a\u5ea7", "\u2648"),
    TAURUS(60, "\u91d1\u725b\u5bae", "\u7261\u725b\u5ea7", "\u2649"),
    GEMINI(90, "\u53cc\u5150\u5bae", "\u53cc\u5b50\u5ea7", "\u264a"),
    CANCER(120, "\u5de8\u87f9\u5bae", "\u87f9\u5ea7", "\u264b"),
    LEO(150, "\u7345\u5b50\u5bae", "\u7345\u5b50\u5ea7", "\u264c"),
    VIRGO(180, "\u51e6\u5973\u5bae", "\u4e59\u5973\u5ea7", "\u264d"),
    LIBRA(210, "\u5929\u79e4\u5bae", "\u5929\u79e4\u5ea7", "\u264e"),
    SCORPIO(240, "\u5929\u874e\u5bae", "\u880d\u5ea7", "\u264f"),
    SAGITTARIUS(270, "\u4eba\u99ac\u5bae", "\u5c04\u624b\u5ea7", "\u2650"),
    CAPRICORN(300, "\u78e8\u7faf\u5bae", "\u5c71\u7f8a\u5ea7", "\u2651"),
    AQUARIUS(330, "\u5b9d\u74f6\u5bae", "\u6c34\u74f6\u5ea7", "\u2652"),
    PISCES(360, "\u53cc\u9b5a\u5bae", "\u9b5a\u5ea7", "\u2653");

    private String[] jp_name;
    private String code;
    private Angle start;
    private Angle end;

    private Zodiac(int a, String jp1, String jp2, String c) {
        this.end = new Angle(a, Angle.Unit.DEGREE);
        this.start = this.end.subtract(new Angle(30, Angle.Unit.DEGREE));
        this.jp_name = new String[]{jp1, jp2};
        this.code = c;
    }

    public String getJpName(boolean constellation) {
        return this.jp_name[constellation ? 1 : 0];
    }

    public String getSymbol() {
        return this.code;
    }

    public boolean isRange(Angle longitude) {
        if (this.start.compareTo(longitude = longitude.convert(Angle.Unit.DEGREE60)) > 0) {
            return false;
        }
        return this.end.compareTo(longitude) > 0;
    }

    public static Zodiac getZodiac(ETD jed, Planet planet) throws AJDException, IOException {
        Pole.PL pole = Pole.plot(jed, planet, Pole.Plane.ECLIPTIC).get(Angle.Unit.SHIFT_DEGREE60, Angle.Unit.DEGREE60);
        for (Zodiac z : Zodiac.values()) {
            if (!z.isRange(pole.lon)) continue;
            return z;
        }
        return null;
    }
}

