/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.iso;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.util.Calc;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class AJD310
extends AJD {
    private ZonedDateTime iso;

    private static String getOffsetHM(ZonedDateTime zdt, boolean std) {
        boolean sub;
        int min = zdt.getOffset().getTotalSeconds() / 60;
        if (min == 0) {
            return "Z";
        }
        int hour = min / 60;
        boolean bl = sub = hour < 0;
        if (sub) {
            hour *= -1;
        }
        if ((min %= 60) < 0) {
            min *= -1;
        }
        String str = String.format(std ? "%02d%02d" : "%02d:%02d", hour, min);
        return (sub ? "-" : "+") + str;
    }

    public String toIsoString(boolean std) {
        return String.format(std ? "%04d%02d%02dT%02d%02d%02d" : "%04d-%02d-%02dT%02d:%02d:%02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond()) + AJD310.getOffsetHM(this.iso, std);
    }

    private static BigDecimal getOffset(ZonedDateTime zdt) {
        if (zdt == null) {
            return Calc.JP_H;
        }
        return Calc.div(new BigDecimal(zdt.getOffset().getTotalSeconds()), Calc.J86400);
    }

    private AJD310(ZonedDateTime zdt) {
        super(Date.from(zdt.toInstant()), AJD310.getOffset(zdt));
        this.iso = zdt;
    }

    public static AJD310 of(ZonedDateTime zdt) {
        return new AJD310(zdt);
    }

    public static AJD310 of(Date date, ZoneId zone) {
        return AJD310.of(ZonedDateTime.ofInstant(date.toInstant(), zone));
    }

    @Override
    protected AJD from(Number num) {
        return AJD310.of(super.from(num), this.iso.getZone());
    }

    @Override
    protected AJD from(int yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        return new AJD310(yyyy, mm, dd, hh, mi, ss, AJD310.getOffset(this.iso));
    }

    public static AJD310 of(Day day, ZoneId zone) {
        return AJD310.of(ZonedDateTime.ofInstant(Instant.ofEpochMilli(day.toAJD().getTime()), zone));
    }

    public static AJD310 now(ZoneId zone) {
        return AJD310.of(ZonedDateTime.now(zone));
    }

    private AJD310(int yyyy, int mm, int dd, int hh, int mi, int ss, BigDecimal offset) throws AJDException {
        super(yyyy, mm, dd, hh, mi, ss, offset);
    }

    public static AJD310 of(int yyyy, int mm, int dd, int hh, int mi, int ss, ZoneId zone) throws DateTimeException {
        return AJD310.of(ZonedDateTime.of(yyyy < 0 ? yyyy + 1 : yyyy, mm, dd, hh, mi, ss, 0, zone));
    }

    public static AJD310 of(int yyyy, int mm, int dd, ZoneId zone) throws AJDException {
        return AJD310.of(yyyy, mm, dd, 0, 0, 0, zone);
    }

    public ZonedDateTime toZonedDateTime() {
        return this.iso;
    }

    public static AJD310[] to(AJD[] src, ZoneId zone) {
        AJD310[] ret = new AJD310[src.length];
        for (int i = 0; i < src.length; ++i) {
            ret[i] = AJD310.of(src[i], zone);
        }
        return ret;
    }
}

