/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.format;

import ajd4jp.format.Numeral;
import ajd4jp.format.RuleWork;

public abstract class Two
extends Numeral {
    private String pad = null;
    private Rule[] spe = null;

    Two(String p, Rule ... s) {
        this.pad = p;
        this.spe = s;
    }

    Two() {
    }

    @Override
    public String toString(int n) {
        Integer[] val = this.split(n);
        for (Rule s : this.spe) {
            String ret = s.work(this, val[0], val[1]);
            if (ret == null) continue;
            return ret;
        }
        char[] num = this.getChar();
        StringBuilder buf = new StringBuilder();
        if (val[0] != null) {
            buf = buf.append(num[val[0]]);
        } else if (this.pad != null) {
            buf = buf.append(this.pad);
        }
        return buf.append(num[val[1]]).toString();
    }

    private Integer[] split(int n) {
        if (n < 0) {
            n *= -1;
        }
        if (n < 10) {
            return new Integer[]{null, n};
        }
        return new Integer[]{n / 10 % 10, n % 10};
    }

    public static enum Rule {
        ZERO(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null && o == 0) {
                    return "\u96f6";
                }
                return null;
            }
        }),
        FIRST(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null && o == 1) {
                    return "\u5143";
                }
                return null;
            }
        }),
        TENTH(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                if (t == 1 && o == 0) {
                    return "\u5341";
                }
                return null;
            }
        }),
        TWENTIETH(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                if (t == 2 && o == 0) {
                    return "\u5eff";
                }
                return null;
            }
        }),
        THIRTIETH(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                if (t == 3 && o == 0) {
                    return "\u5345";
                }
                return null;
            }
        }),
        MULTIPLE_TEN(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null || o != 0) {
                    return null;
                }
                String ret = TENTH.work(n, t, o);
                if (ret != null) {
                    return ret;
                }
                StringBuilder buf = new StringBuilder();
                return buf.append(n.getChar()[t]).append("\u5341").toString();
            }
        }),
        TENS(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                if (t != 1) {
                    return null;
                }
                String ret = TENTH.work(n, t, o);
                if (ret != null) {
                    return ret;
                }
                StringBuilder buf = new StringBuilder("\u5341");
                return buf.append(n.getChar()[o]).toString();
            }
        }),
        TWENTIES(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                if (t != 2) {
                    return null;
                }
                String ret = TWENTIETH.work(n, t, o);
                if (ret != null) {
                    return ret;
                }
                StringBuilder buf = new StringBuilder("\u5eff");
                return buf.append(n.getChar()[o]).toString();
            }
        }),
        THIRTIES(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                if (t != 3) {
                    return null;
                }
                String ret = THIRTIETH.work(n, t, o);
                if (ret != null) {
                    return ret;
                }
                StringBuilder buf = new StringBuilder("\u5345");
                return buf.append(n.getChar()[o]).toString();
            }
        }),
        TRIPLE(new RuleWork(){

            @Override
            public String toString(Numeral n, Integer t, Integer o) {
                if (t == null) {
                    return null;
                }
                String str = MULTIPLE_TEN.work(n, t, o);
                if (str != null) {
                    return str;
                }
                str = TENS.work(n, t, o);
                if (str != null) {
                    return str;
                }
                char[] num = n.getChar();
                StringBuilder buf = new StringBuilder();
                return buf.append(num[t]).append("\u5341").append(num[o]).toString();
            }
        });

        private RuleWork work;

        private Rule(RuleWork w) {
            this.work = w;
        }

        String work(Numeral n, Integer t, Integer o) {
            return this.work.toString(n, t, o);
        }
    }
}

