/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.Day;
import ajd4jp.EarthlyBranch;
import ajd4jp.util.Calc;

public enum HeavenlyStem {
    KOU("\u7532", 0),
    OTSU("\u4e59", 1),
    HEI("\u4e19", 2),
    TEI("\u4e01", 3),
    BO("\u620a", 4),
    KI("\u5df1", 5),
    KO("\u5e9a", 6),
    SHIN("\u8f9b", 7),
    JIN("\u58ec", 8),
    CI("\u7678", 9);

    private String name;
    private int no;
    private static final HeavenlyStem[] hs;

    private HeavenlyStem(String s, int n2) {
        this.name = s;
        this.no = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getNo() {
        return this.no;
    }

    private static HeavenlyStem fix(int v) {
        if ((v %= hs.length) < 0) {
            v += hs.length;
        }
        return hs[v];
    }

    public static HeavenlyStem getYear(Day date) {
        int yy = date.getYear();
        if (yy < 0) {
            ++yy;
        }
        return HeavenlyStem.fix(yy - 4);
    }

    public static HeavenlyStem getMonth(Day date) {
        int yy = date.getYear();
        if (yy < 0) {
            ++yy;
        }
        return HeavenlyStem.fix(yy % 5 * 2 + 3 + date.getMonth());
    }

    public static HeavenlyStem getDay(Day date) {
        AJD ajd = new AJD(date.getAJD());
        return HeavenlyStem.fix((int)Calc.cut(ajd.trim().getAJD()));
    }

    public static HeavenlyStem getTime(Day date) {
        AJD ajd = new AJD(date.getAJD());
        if (ajd.getHour() == 23) {
            ajd = ajd.addHour(1L);
        }
        HeavenlyStem day = HeavenlyStem.getDay(ajd);
        EarthlyBranch hour = EarthlyBranch.getTime(ajd);
        return HeavenlyStem.fix(day.getNo() % 5 * 2 + hour.getNo());
    }

    static {
        hs = HeavenlyStem.values();
    }
}

