/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery;

import ajd4jp.orrery.MinDecimal;
import ajd4jp.util.Calc;
import java.io.Serializable;
import java.math.BigDecimal;

public class Angle
implements Serializable,
Comparable<Angle> {
    private static final long serialVersionUID = 1L;
    public static final BigDecimal MZ = new MinDecimal(BigDecimal.ZERO, true);
    private Unit unit;
    MinDecimal h = null;
    BigDecimal m = null;
    BigDecimal s = null;
    static final BigDecimal PI = new BigDecimal(Math.PI);
    static final BigDecimal A180 = new BigDecimal(180);
    static final BigDecimal A360 = new BigDecimal(360);
    static final BigDecimal A24 = new BigDecimal(24);
    static final BigDecimal A12 = new BigDecimal(12);
    static final BigDecimal A_12 = new BigDecimal(-12);
    static final BigDecimal A15 = new BigDecimal(15);
    static final BigDecimal A60 = new BigDecimal(60);
    static final BigDecimal A6060 = A60.multiply(A60);
    static final BigDecimal SEC = A6060.multiply(A24);
    static final BigDecimal DperS = SEC.divide(A360);

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Calc.toString(this.h));
        switch (this.unit) {
            case RADIAN: {
                buf.append("(").append(Calc.toString(Calc.div((BigDecimal)this.h, PI))).append("\u03c0)rad");
                break;
            }
            case SECOND: {
                buf.append("\u2033");
                break;
            }
            case HOUR: {
                buf.append(":");
                break;
            }
            default: {
                buf.append("\u00b0");
            }
        }
        if (this.unit.ms_f) {
            if (this.unit == Unit.HOUR) {
                buf.append(Calc.toString(this.m)).append(":");
                buf.append(Calc.toString(this.s));
            } else {
                buf.append(Calc.toString(this.m)).append("\u2032");
                String[] sec = Calc.toString(this.s).split("\\.");
                buf.append(sec[0]).append("\u2033");
                if (sec.length > 1) {
                    buf.append(".").append(sec[1]);
                }
            }
        }
        return buf.toString();
    }

    public BigDecimal getTop() {
        return this.h;
    }

    public BigDecimal getMinute() {
        return this.m;
    }

    public BigDecimal getSecond() {
        return this.s;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Angle(Number top, Number min, Number sec, Unit u) {
        boolean nz_f = false;
        this.unit = u;
        if (top instanceof MinDecimal) {
            this.h = (MinDecimal)top;
            nz_f = this.h.getNZ();
        } else {
            this.h = new MinDecimal(new BigDecimal(top.toString()), false);
        }
        if (!u.ms_f) {
            return;
        }
        this.m = new BigDecimal(min.toString());
        this.s = new BigDecimal(sec.toString());
        int hh = this.h.intValue();
        this.h = new MinDecimal(this.h.subtract(new BigDecimal(hh)), false);
        this.m = this.m.add(this.h.multiply(A60));
        int mm = this.m.intValue();
        this.m = this.m.subtract(new BigDecimal(mm));
        this.s = this.s.add(this.m.multiply(A60));
        while (true) {
            if (this.s.compareTo(BigDecimal.ZERO) < 0) {
                this.s = this.s.add(A60);
                --mm;
                continue;
            }
            if (this.s.compareTo(A60) < 0) break;
            this.s = this.s.subtract(A60);
            ++mm;
        }
        while (true) {
            if (mm < 0) {
                mm += 60;
                --hh;
                continue;
            }
            if (mm < 60) break;
            mm -= 60;
            ++hh;
        }
        this.m = new BigDecimal(mm);
        if (this.unit == Unit.HOUR) {
            if ((hh %= 24) < 0) {
                hh += 24;
            }
        } else {
            hh %= 360;
            if (this.unit == Unit.DEGREE60) {
                if (hh < 0) {
                    hh += 360;
                }
            } else {
                if (hh < -180) {
                    hh = 360 + hh;
                }
                if (hh >= 180) {
                    hh -= 360;
                }
            }
        }
        this.h = new MinDecimal(new BigDecimal(hh), nz_f);
    }

    public Angle(Number top, Unit u) {
        this(top, u.ms_f ? Integer.valueOf(0) : null, u.ms_f ? Integer.valueOf(0) : null, u);
    }

    public Angle convert(Unit to) {
        if (this.unit == to) {
            return this;
        }
        BigDecimal dh = this.h;
        BigDecimal dm = this.m;
        BigDecimal ds = this.s;
        if (this.unit != Unit.DEGREE) {
            switch (this.unit) {
                case HOUR: {
                    dh = dh.multiply(A6060).add(dm.multiply(A60)).add(ds);
                    dh = Calc.div(dh, DperS);
                    break;
                }
                case SECOND: {
                    dh = Calc.div(dh, A6060);
                    break;
                }
                case SHIFT_DEGREE60: {
                    if (dh.compareTo(BigDecimal.ZERO) < 0) {
                        dh = dh.subtract(Calc.div(dm, A60)).subtract(Calc.div(ds, A6060));
                        break;
                    }
                }
                case DEGREE60: {
                    dh = dh.add(Calc.div(dm, A60)).add(Calc.div(ds, A6060));
                    break;
                }
                case RADIAN: {
                    dh = Calc.div(dh.multiply(A180), PI);
                }
            }
        }
        ds = null;
        dm = null;
        if (to == Unit.RADIAN) {
            dh = Calc.div(dh.multiply(PI), A180);
        } else if (to == Unit.SECOND) {
            dh = dh.multiply(A6060);
        } else if (to.ms_f) {
            boolean nega_f = false;
            if (dh.compareTo(BigDecimal.ZERO) < 0 && to == Unit.SHIFT_DEGREE60) {
                nega_f = true;
                dh = dh.negate();
            }
            while (true) {
                if (dh.compareTo(BigDecimal.ZERO) < 0) {
                    dh = dh.add(A360);
                    continue;
                }
                if (dh.compareTo(A360) < 0) break;
                dh = dh.subtract(A360);
            }
            if (to == Unit.DEGREE60 || to == Unit.SHIFT_DEGREE60) {
                dm = dh;
                dh = new BigDecimal(dm.intValue());
                ds = dm.subtract(dh).multiply(A60);
                dm = new BigDecimal(ds.intValue());
                ds = ds.subtract(dm).multiply(A60);
                if (to == Unit.SHIFT_DEGREE60 && nega_f) {
                    dh = new MinDecimal(dh.negate(), true);
                }
            } else if (to != Unit.DEGREE) {
                ds = dh.multiply(DperS);
                dm = new BigDecimal(Calc.div(ds, A60).intValue());
                ds = ds.subtract(dm.multiply(A60));
                dh = new BigDecimal(Calc.div(dm, A60).intValue());
                dm = new BigDecimal(dm.subtract(dh.multiply(A60)).intValue());
            }
        }
        return new Angle(dh, dm, ds, to);
    }

    public Angle add(Angle a) {
        BigDecimal ret = this.convert((Unit)Unit.DEGREE).h;
        ret = ret.add(a.convert((Unit)Unit.DEGREE).h);
        return new Angle(ret, Unit.DEGREE).convert(this.unit);
    }

    public Angle subtract(Angle a) {
        BigDecimal ret = this.convert((Unit)Unit.DEGREE).h;
        ret = ret.subtract(a.convert((Unit)Unit.DEGREE).h);
        return new Angle(ret, Unit.DEGREE).convert(this.unit);
    }

    @Override
    public int compareTo(Angle a) {
        Angle[] c = new Angle[]{this.convert(Unit.DEGREE), a.convert(Unit.DEGREE)};
        return c[0].h.compareTo(c[1].h);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Angle)) {
            return false;
        }
        return this.compareTo((Angle)o) == 0;
    }

    public int hashCode() {
        return this.convert((Unit)Unit.DEGREE).h.hashCode();
    }

    public static enum Unit {
        RADIAN(false),
        DEGREE(false),
        DEGREE60(true),
        SHIFT_DEGREE60(true),
        HOUR(true),
        SECOND(false);

        boolean ms_f;

        private Unit(boolean f) {
            this.ms_f = f;
        }
    }
}

