/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.format;

import ajd4jp.Day;
import ajd4jp.format.Dummy;
import ajd4jp.format.Format;
import ajd4jp.format.FullArabia;
import ajd4jp.format.HalfArabia;
import ajd4jp.format.Japan;
import java.util.HashMap;

public class C
extends Format {
    private String str;

    public static boolean checkAllow(String s, char[] allow, char[] deny, Type[] allow_type, Type[] deny_type) {
        if (s == null || s.length() == 0) {
            return true;
        }
        if (deny != null) {
            for (char x : s.toCharArray()) {
                for (char y : deny) {
                    if (x != y) continue;
                    return false;
                }
            }
        }
        if (deny_type != null) {
            for (Type t : deny_type) {
                if (s.length() == t.delete(s).length()) continue;
                return false;
            }
        }
        if (!(allow != null && allow.length != 0 || allow_type != null && allow_type.length != 0)) {
            return true;
        }
        for (Type t : allow_type) {
            if ((s = t.delete(s)).length() != 0) continue;
            return true;
        }
        if (allow == null || allow.length == 0) {
            return false;
        }
        for (char x : s.toCharArray()) {
            boolean flag = false;
            for (char y : allow) {
                boolean bl = flag = x == y;
                if (flag) break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAllow(String s, char[] allow, Type ... allow_type) {
        return C.checkAllow(s, allow, null, allow_type, null);
    }

    public static boolean checkAllow(String s, Type ... allow_type) {
        return C.checkAllow(s, null, null, allow_type, null);
    }

    public C(String s) {
        super(Dummy.dmy);
        this.str = s;
        if (this.str == null) {
            this.str = "";
        }
    }

    @Override
    int getNum(Day date) {
        return 0;
    }

    @Override
    String getHead() {
        return this.str;
    }

    public static enum Kana implements Type
    {
        FULL("\u30a2", "\u30a4", "\u30a6", "\u30a8", "\u30aa", "\u30ab", "\u30ad", "\u30af", "\u30b1", "\u30b3", "\u30b5", "\u30b7", "\u30b9", "\u30bb", "\u30bd", "\u30bf", "\u30c1", "\u30c4", "\u30c6", "\u30c8", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d2", "\u30d5", "\u30d8", "\u30db", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e4", "\u30e6", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f0", "\u30f1", "\u30f2", "\u30f3", "\u30ac", "\u30ae", "\u30b0", "\u30b2", "\u30b4", "\u30b6", "\u30b8", "\u30ba", "\u30bc", "\u30be", "\u30c0", "\u30c2", "\u30c5", "\u30c7", "\u30c9", "\u30d0", "\u30d3", "\u30d6", "\u30d9", "\u30dc", "\u30d1", "\u30d4", "\u30d7", "\u30da", "\u30dd", "\u30f4", "\u30fc", "\u30a1", "\u30a3", "\u30a5", "\u30a7", "\u30a9", "\u30e3", "\u30e5", "\u30e7", "\u30c3"),
        HALF("\uff71", "\uff72", "\uff73", "\uff74", "\uff75", "\uff76", "\uff77", "\uff78", "\uff79", "\uff7a", "\uff7b", "\uff7c", "\uff7d", "\uff7e", "\uff7f", "\uff80", "\uff81", "\uff82", "\uff83", "\uff84", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8b", "\uff8c", "\uff8d", "\uff8e", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff94", "\uff95", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff72", "\uff74", "\uff66", "\uff9d", "\uff76\uff9e", "\uff77\uff9e", "\uff78\uff9e", "\uff79\uff9e", "\uff7a\uff9e", "\uff7b\uff9e", "\uff7c\uff9e", "\uff7d\uff9e", "\uff7e\uff9e", "\uff7f\uff9e", "\uff80\uff9e", "\uff81\uff9e", "\uff82\uff9e", "\uff83\uff9e", "\uff84\uff9e", "\uff8a\uff9e", "\uff8b\uff9e", "\uff8c\uff9e", "\uff8d\uff9e", "\uff8e\uff9e", "\uff8a\uff9f", "\uff8b\uff9f", "\uff8c\uff9f", "\uff8d\uff9f", "\uff8e\uff9f", "\uff73\uff9e", "\uff70", "\uff67", "\uff68", "\uff69", "\uff6a", "\uff6b", "\uff6c", "\uff6d", "\uff6e", "\uff6f"),
        HIRA("\u3042", "\u3044", "\u3046", "\u3048", "\u304a", "\u304b", "\u304d", "\u304f", "\u3051", "\u3053", "\u3055", "\u3057", "\u3059", "\u305b", "\u305d", "\u305f", "\u3061", "\u3064", "\u3066", "\u3068", "\u306a", "\u306b", "\u306c", "\u306d", "\u306e", "\u306f", "\u3072", "\u3075", "\u3078", "\u307b", "\u307e", "\u307f", "\u3080", "\u3081", "\u3082", "\u3084", "\u3086", "\u3088", "\u3089", "\u308a", "\u308b", "\u308c", "\u308d", "\u308f", "\u3090", "\u3091", "\u3092", "\u3093", "\u304c", "\u304e", "\u3050", "\u3052", "\u3054", "\u3056", "\u3058", "\u305a", "\u305c", "\u305e", "\u3060", "\u3062", "\u3065", "\u3067", "\u3069", "\u3070", "\u3073", "\u3076", "\u3079", "\u307c", "\u3071", "\u3074", "\u3077", "\u307a", "\u307d", "\u3046\u309b", "\u30fc", "\u3041", "\u3043", "\u3045", "\u3047", "\u3049", "\u3083", "\u3085", "\u3087", "\u3063");

        private String[] data;
        private HashMap<String, Integer> map = new HashMap();

        private Kana(String ... s) {
            this.data = s;
            for (int i = 0; i < s.length; ++i) {
                this.map.put(s[i], i);
            }
        }

        @Override
        public String delete(String org) {
            if (org == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            int len = org.length();
            for (int i = 0; i < len; ++i) {
                String test;
                if (i < len - 1 && this.map.get(test = org.substring(i, i + 2)) != null) {
                    ++i;
                    continue;
                }
                test = org.substring(i, i + 1);
                if (this.map.get(test) != null) continue;
                buf = buf.append(test);
            }
            return buf.toString();
        }

        private int getNo(String s, Kana ... target) {
            for (Kana k : target) {
                Integer no;
                if (k == this || (no = k.map.get(s)) == null) continue;
                return no;
            }
            return -1;
        }

        public String convert(String org, Kana ... target) {
            if (org == null) {
                return null;
            }
            if (target == null || target.length == 0) {
                return this.convert(org, Kana.values());
            }
            StringBuilder buf = new StringBuilder();
            int len = org.length();
            boolean flag = false;
            for (int i = 0; i < len; ++i) {
                int no = -1;
                if (i < len - 1 && (no = this.getNo(org.substring(i, i + 2), target)) >= 0) {
                    buf = buf.append(this.data[no]);
                    ++i;
                    flag = true;
                    continue;
                }
                String test = org.substring(i, i + 1);
                no = this.getNo(test, target);
                if (no >= 0) {
                    buf = buf.append(this.data[no]);
                    flag = true;
                    continue;
                }
                buf = buf.append(test);
            }
            if (flag) {
                return buf.toString();
            }
            return org;
        }
    }

    public static enum Alphabet implements Type
    {
        FULL_UP('\uff21', '\uff3a'),
        HALF_UP('A', 'Z'),
        FULL_LOW('\uff41', '\uff5a'),
        HALF_LOW('a', 'z');

        private static final int MAX = 25;
        private char start;
        private char end;

        private Alphabet(char s, char e) {
            this.start = s;
            this.end = e;
        }

        @Override
        public String delete(String org) {
            if (org == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (char ch : org.toCharArray()) {
                if (ch >= this.start && ch <= this.end) continue;
                buf = buf.append(ch);
            }
            return buf.toString();
        }

        public String convert(String org, Alphabet ... target) {
            if (org == null) {
                return null;
            }
            if (target == null || target.length == 0) {
                return this.convert(org, Alphabet.values());
            }
            char[] ch = org.toCharArray();
            boolean flag = false;
            for (int i = 0; i < ch.length; ++i) {
                Integer no = null;
                for (Alphabet t : target) {
                    int sub;
                    if (t == this || (sub = ch[i] - t.start) < 0 || sub > 25) continue;
                    no = sub;
                    break;
                }
                if (no == null) continue;
                ch[i] = (char)(this.start + no);
                flag = true;
            }
            if (flag) {
                return new String(ch);
            }
            return org;
        }
    }

    public static enum Numeral implements Type
    {
        FULL(FullArabia.num),
        HALF(HalfArabia.num),
        JAPAN(Japan.num);

        private char[] data;
        private HashMap<Character, Integer> map = new HashMap();

        private Numeral(char[] ch) {
            this.data = ch;
            for (int i = 0; i < ch.length; ++i) {
                this.map.put(Character.valueOf(ch[i]), i);
            }
        }

        @Override
        public String delete(String org) {
            if (org == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (char ch : org.toCharArray()) {
                if (this.map.get(Character.valueOf(ch)) != null) continue;
                buf = buf.append(ch);
            }
            return buf.toString();
        }

        public String convert(String org, Numeral ... target) {
            if (org == null) {
                return null;
            }
            if (target == null || target.length == 0) {
                return this.convert(org, Numeral.values());
            }
            char[] ch = org.toCharArray();
            boolean flag = false;
            for (int i = 0; i < ch.length; ++i) {
                Integer no = null;
                for (Numeral t : target) {
                    if (t != this && (no = t.map.get(Character.valueOf(ch[i]))) != null) break;
                }
                if (no == null) continue;
                ch[i] = this.data[no];
                flag = true;
            }
            if (flag) {
                return new String(ch);
            }
            return org;
        }
    }

    public static enum Symbol implements Type
    {
        FULL("\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff3b\uffe5\uff3d\uff3e\uff3f\u2018\uff5b\uff5c\uff5d\uff5e\uff61\u300c\u300d\uff64\u30fb\u309b\u309c".toCharArray()),
        HALF("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~\uff61\uff62\uff63\uff64\uff65\uff9e\uff9f".toCharArray());

        private char[] data;
        private HashMap<Character, Integer> map = new HashMap();

        private Symbol(char[] ch) {
            this.data = ch;
            for (int i = 0; i < ch.length; ++i) {
                this.map.put(Character.valueOf(ch[i]), i);
            }
        }

        @Override
        public String delete(String org) {
            if (org == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (char ch : org.toCharArray()) {
                if (this.map.get(Character.valueOf(ch)) != null) continue;
                buf = buf.append(ch);
            }
            return buf.toString();
        }

        public String convert(String org) {
            if (org == null) {
                return null;
            }
            Symbol anti = this == FULL ? HALF : FULL;
            char[] ch = org.toCharArray();
            boolean flag = false;
            for (int i = 0; i < ch.length; ++i) {
                Integer no = anti.map.get(Character.valueOf(ch[i]));
                if (no == null) continue;
                ch[i] = this.data[no];
                flag = true;
            }
            if (flag) {
                return new String(ch);
            }
            return org;
        }
    }

    public static enum Space implements Type
    {
        FULL('\u3000'),
        HALF(' ');

        private char sp;

        private Space(char s) {
            this.sp = s;
        }

        @Override
        public String delete(String org) {
            if (org == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (char ch : org.toCharArray()) {
                if (ch == this.sp || ch == '\u007f' || ch < ' ') continue;
                buf = buf.append(ch);
            }
            return buf.toString();
        }

        public String convert(String org) {
            if (org == null) {
                return null;
            }
            Space anti = this == FULL ? HALF : FULL;
            char[] ch = org.toCharArray();
            boolean flag = false;
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] != anti.sp) continue;
                ch[i] = this.sp;
                flag = true;
            }
            if (flag) {
                return new String(ch);
            }
            return org;
        }
    }

    public static interface Type {
        public String delete(String var1);
    }
}

