/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.FYD;
import ajd4jp.Month;
import java.io.Serializable;

public class FiscalYear
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static AJD START4 = null;
    private int start_m;
    private int start_d;
    private int start_h;
    private Boolean mon_f;
    private Boolean day_f;
    private Boolean hour_f;

    public FiscalYear() {
        this(START4, true);
    }

    public FiscalYear(AJD start_day, boolean year_of_start_day) {
        this(start_day, year_of_start_day, null, null);
    }

    public FiscalYear(AJD start_day, Boolean year_of_start_day, Boolean month_of_start_day, Boolean day_of_start_hour) {
        this.start_m = start_day.getMonth();
        this.start_d = start_day.getDay();
        this.start_h = start_day.getHour();
        this.mon_f = year_of_start_day;
        this.day_f = month_of_start_day;
        this.hour_f = day_of_start_hour;
    }

    private AJD getStart(int y, int m, int d, int h) {
        try {
            return new AJD(y, m, d, h, 0, 0);
        }
        catch (AJDException e) {
            return this.getStart(y, m, d - 1, h);
        }
    }

    int[] getDate(AJD ajd) {
        ajd = this.getDay(ajd);
        Month m = this.getMonth(ajd);
        ajd = this.getStart(m.getYear(), m.getMonth(), ajd.getDay(), ajd.getHour());
        return new int[]{this.getYear(ajd), m.getMonth(), ajd.getDay()};
    }

    private int getYear(AJD ajd) {
        int y = ajd.getYear();
        if (this.mon_f == null) {
            return y;
        }
        AJD st = this.getStart(y, this.start_m, this.start_d, ajd.getHour());
        if (st.compareTo(ajd) > 0 && this.mon_f.booleanValue()) {
            if (--y == 0) {
                --y;
            }
        } else if (st.compareTo(ajd) <= 0 && !this.mon_f.booleanValue() && ++y == 0) {
            ++y;
        }
        return y;
    }

    private Month getMonth(AJD ajd) {
        int y = ajd.getYear();
        int m = ajd.getMonth();
        Month ret = new Month(ajd);
        if (this.day_f == null) {
            return ret;
        }
        AJD st = this.getStart(y, m, this.start_d, ajd.getHour());
        if (st.compareTo(ajd) > 0 && this.day_f.booleanValue()) {
            return ret.add(-1);
        }
        if (st.compareTo(ajd) <= 0 && !this.day_f.booleanValue()) {
            return ret.add(1);
        }
        return ret;
    }

    private AJD getDay(AJD ajd) {
        int d;
        int m;
        if (this.hour_f == null) {
            return ajd;
        }
        int y = ajd.getYear();
        AJD st = this.getStart(y, m = ajd.getMonth(), d = ajd.getDay(), this.start_h);
        if (st.compareTo(ajd) > 0 && this.hour_f.booleanValue()) {
            return ajd.addDay(-1);
        }
        if (st.compareTo(ajd) <= 0 && !this.hour_f.booleanValue()) {
            return ajd.addDay(1);
        }
        return ajd;
    }

    public FYD getFYD(AJD day) {
        return new FYD(this, day);
    }

    public FYD getFYD(int yyyy, int mm, int dd) throws AJDException {
        return this.getFYD(yyyy, mm, dd, 0, 0, 0);
    }

    private AJD getAJD(int yyyy, int mm, int dd, int hh, int mi, int ss) {
        try {
            if (dd < 1) {
                if (--mm < 1) {
                    mm = 12;
                    if (--yyyy == 0) {
                        yyyy = -1;
                    }
                }
                dd = Month.getLastDay(yyyy, mm);
            } else if (dd > Month.getLastDay(yyyy, mm)) {
                if (++mm > 12) {
                    mm = 1;
                    if (++yyyy == 0) {
                        yyyy = 1;
                    }
                }
                dd = 1;
            }
            if (mm < 1) {
                mm = 12;
                if (--yyyy == 0) {
                    yyyy = -1;
                }
                return this.getAJD(yyyy, mm, dd, hh, mi, ss);
            }
            if (mm > 12) {
                mm = 1;
                if (++yyyy == 0) {
                    yyyy = 1;
                }
                return this.getAJD(yyyy, mm, dd, hh, mi, ss);
            }
            return new AJD(yyyy, mm, dd, hh, mi, ss);
        }
        catch (AJDException e) {
            return null;
        }
    }

    public FYD getFYD(int yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        FYD[] fyd = new FYD[]{new FYD(this, this.getAJD(yyyy == 1 ? -1 : yyyy - 1, mm, dd, hh, mi, ss)), new FYD(this, this.getAJD(yyyy, mm - 1, dd, hh, mi, ss)), new FYD(this, this.getAJD(yyyy, mm, dd - 1, hh, mi, ss)), new FYD(this, this.getAJD(yyyy, mm, dd, hh, mi, ss)), new FYD(this, this.getAJD(yyyy, mm, dd + 1, hh, mi, ss)), new FYD(this, this.getAJD(yyyy, mm + 1, dd, hh, mi, ss)), new FYD(this, this.getAJD(yyyy == -1 ? 1 : yyyy + 1, mm, dd, hh, mi, ss))};
        for (int i = 0; i < fyd.length; ++i) {
            if (fyd[i].ajd == null || fyd[i].getYear() != yyyy || fyd[i].getMonth() != mm || fyd[i].getDay() != dd) continue;
            return fyd[i];
        }
        throw new AJDException("\u6307\u5b9a\u65e5\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
    }

    static {
        try {
            START4 = new AJD(2000, 4, 1);
        }
        catch (AJDException aJDException) {
            // empty catch block
        }
    }
}

