/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Holy;
import ajd4jp.Week;
import java.io.Serializable;

public class Month
implements Comparable<Month>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] eng3 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] eng = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    static final String[] jp = new String[]{"\u7766\u6708", "\u5982\u6708", "\u5f25\u751f", "\u536f\u6708", "\u7690\u6708", "\u6c34\u7121\u6708", "\u6587\u6708", "\u8449\u6708", "\u9577\u6708", "\u795e\u7121\u6708", "\u971c\u6708", "\u5e2b\u8d70"};
    private int y;
    private int m;
    private transient Month pre_m = null;
    private transient Month after_m = null;
    private transient AJD[] ajd = null;

    private Month() {
    }

    public Month(int yyyy, int mm) throws AJDException {
        AJD.check(yyyy, mm);
        this.y = yyyy;
        this.m = mm;
    }

    public int getYear() {
        return this.y;
    }

    public int getMonth() {
        return this.m;
    }

    public Month add(int mm) {
        if (mm == 0) {
            return this;
        }
        if (mm == -1 && this.pre_m != null) {
            return this.pre_m;
        }
        if (mm == 1 && this.after_m != null) {
            return this.after_m;
        }
        int org = mm;
        int yy = this.y;
        mm += this.m;
        while (true) {
            if (mm < 1) {
                mm += 12;
                if (--yy != 0) continue;
                --yy;
                continue;
            }
            if (mm <= 12) break;
            mm -= 12;
            if (++yy != 0) continue;
            ++yy;
        }
        Month ret = null;
        try {
            ret = new Month(yy, mm);
        }
        catch (AJDException e) {
            // empty catch block
        }
        if (org == -1) {
            this.pre_m = ret;
            this.pre_m.after_m = this;
        } else if (org == 1) {
            this.after_m = ret;
            this.after_m.pre_m = this;
        }
        return ret;
    }

    public int getLastDay() {
        if (this.m == 2) {
            int uy = 0;
            if (this.y % 4 == 0) {
                if (this.y % 100 == 0 && this.y > 1582) {
                    if (this.y % 400 == 0) {
                        uy = 1;
                    }
                } else {
                    uy = 1;
                }
            }
            return days[1] + uy;
        }
        return days[this.m - 1];
    }

    public AJD[] getDays() {
        if (this.ajd != null) {
            return this.ajd;
        }
        AJD[] d = new AJD[this.getLastDay()];
        for (int i = 0; i < d.length; ++i) {
            try {
                d[i] = new AJD(this.y, this.m, i + 1);
                continue;
            }
            catch (AJDException aJDException) {
                // empty catch block
            }
        }
        this.ajd = d;
        return d;
    }

    Holy[] getHolis() {
        Holy[] d = new Holy[this.getLastDay()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new Holy(this.y, this.m, i + 1);
        }
        return d;
    }

    public AJD getWeek(int seq, Week week) {
        AJD[] d = this.getDays();
        int hit = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getWeek() != week) continue;
            if (seq == ++hit) {
                return d[i];
            }
            i += 6;
        }
        return null;
    }

    public AJD[] getWeek(int seq, boolean supp_f) {
        int n;
        if (seq < 1) {
            return null;
        }
        AJD[] ret = new AJD[7];
        AJD[] d = this.getDays();
        int start = (seq - 1) * 7;
        if (start == 0) {
            int n2 = 0;
            int left = d[0].getWeek().get();
            if (left > 0) {
                AJD[] pre = this.add(-1).getDays();
                int i = pre.length - left;
                while (i < pre.length) {
                    ret[n2] = supp_f ? pre[i] : null;
                    ++i;
                    ++n2;
                }
            }
            int i = 0;
            while (n2 < ret.length) {
                ret[n2] = d[i];
                ++n2;
                ++i;
            }
            return ret;
        }
        if (start < d.length) {
            start -= d[start].getWeek().get();
        } else {
            if ((start -= ret.length) >= d.length) {
                return null;
            }
            if ((start = start + ret.length - d[start].getWeek().get()) >= d.length) {
                return null;
            }
        }
        for (n = 0; start < d.length && n < ret.length; ++start, ++n) {
            ret[n] = d[start];
        }
        if (n == ret.length || !supp_f) {
            return ret;
        }
        AJD[] after = this.add(1).getDays();
        int i = 0;
        while (n < ret.length) {
            ret[n] = after[i];
            ++n;
            ++i;
        }
        return ret;
    }

    public String getShortName() {
        return eng3[this.m - 1];
    }

    public String getLongName() {
        return eng[this.m - 1];
    }

    public String getJpName() {
        return jp[this.m - 1];
    }

    @Override
    public int compareTo(Month mon) {
        int ret = this.y - mon.y;
        if (ret == 0) {
            ret = this.m - mon.m;
        }
        if (ret > 0) {
            return 1;
        }
        if (ret < 0) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.y << 4 | this.m;
    }

    public boolean equals(Object o) {
        if (o instanceof Month) {
            return this.compareTo((Month)o) == 0;
        }
        return false;
    }

    public String toString() {
        return String.format("%d/%02d", this.y, this.m);
    }
}

