/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.Day;
import ajd4jp.Month;
import ajd4jp.Span;
import java.math.BigDecimal;

public class LSCD
implements Day {
    private static final long serialVersionUID = 1L;
    private int year;
    private int mon;
    private int day;
    private boolean leap_f;
    private AJD ajd;

    LSCD(int y, boolean f, int m, int d, AJD mine) {
        this.year = y;
        this.mon = m;
        this.leap_f = f;
        this.day = d;
        this.ajd = mine;
    }

    LSCD(int y, boolean f, int m, AJD start, AJD mine) {
        this(y, f, m, new Span(start, mine).getDayPart() + 1, mine);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.mon;
    }

    public boolean isLeapMonth() {
        return this.leap_f;
    }

    public String getMonthName() {
        StringBuilder buf = new StringBuilder(this.leap_f ? "\u958f" : "");
        return buf.append(Month.jp[this.mon - 1]).toString();
    }

    public int getDay() {
        return this.day;
    }

    public Rokuyo getRokuyo() {
        return Rokuyo.values()[(this.mon + this.day - 2) % 6];
    }

    public AJD toAJD() {
        return this.ajd;
    }

    @Override
    public BigDecimal getAJD() {
        return this.ajd.getAJD();
    }

    public String toString() {
        String leap = this.leap_f ? "\u958f" : "";
        return String.format("%d/%s%02d/%02d", this.year, leap, this.mon, this.day);
    }

    @Override
    public int compareTo(Day jd) {
        return this.ajd.compareTo(jd);
    }

    public int hashCode() {
        return this.ajd.hashCode();
    }

    public boolean equals(Object o) {
        return this.ajd.equals(o);
    }

    public static enum Rokuyo {
        SENSHO("\u5148\u52dd"),
        TOMOBIKI("\u53cb\u5f15"),
        SENBU("\u5148\u8ca0"),
        BUTSUMETSU("\u4ecf\u6ec5"),
        TAIAN("\u5927\u5b89"),
        SHAKKO("\u8d64\u53e3");

        private String name;

        private Rokuyo(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }
}

