/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.EraWork;
import java.io.Serializable;

public enum Era {
    MEIJI("\u660e\u6cbb", EraWork.st_ed[0][0], EraWork.st_ed[0][1]),
    TAISHO("\u5927\u6b63", EraWork.st_ed[1][0], EraWork.st_ed[1][1]),
    SHOWA("\u662d\u548c", EraWork.st_ed[2][0], EraWork.st_ed[2][1]),
    HEISEI("\u5e73\u6210", EraWork.st_ed[3][0], EraWork.st_ed[3][1]);

    private String name;
    private AJD start;
    private AJD end = null;

    private Era(String n2, AJD s, AJD e) {
        this.name = n2;
        this.start = s;
        this.end = e;
    }

    static Era get(AJD ajd) {
        Era[] era = Era.values();
        for (int i = era.length - 1; i >= 0; --i) {
            if (era[i].start.compareTo(ajd) > 0) continue;
            return era[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public AJD getStart() {
        return this.start;
    }

    public AJD getEnd() {
        return this.end;
    }

    public int getAD(int yy) {
        return this.start.getYear() + yy - 1;
    }

    private int getYear(int yyyy) {
        return yyyy - this.start.getYear() + 1;
    }

    public static class Year
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Era era;
        private int yy;

        private Year() {
        }

        Year(AJD ajd) {
            this.era = Era.get(ajd);
            int y4 = ajd.getYear();
            this.yy = this.era == null ? y4 : this.era.getYear(y4);
        }

        public Era getEra() {
            return this.era;
        }

        public int getYear() {
            return this.yy;
        }

        public String toString() {
            return String.format("%s%d\u5e74", this.era == null ? "" : this.era.getName(), this.yy);
        }
    }
}

